/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.SensitiveAutoParameter;
import org.neo4j.cypher.internal.expressions.SensitiveLiteral;
import org.neo4j.cypher.internal.expressions.SensitiveParameter;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.StepSequencer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class ObfuscationMetadataCollection$
implements Phase<BaseContext, BaseState, BaseState>,
Product,
scala.Serializable {
    public static ObfuscationMetadataCollection$ MODULE$;

    static {
        new ObfuscationMetadataCollection$();
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$(this, state, conditions);
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.METADATA_COLLECTION;
    }

    @Override
    public Set<StepSequencer.Condition> postConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    @Override
    public BaseState process(BaseState from, BaseContext context) {
        Set extractedParamNames = (Set)from.maybeExtractedParams().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.keys().toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        Seq parameters = from.statement().folder().findAllByClass(ClassTag$.MODULE$.apply(Parameter.class));
        Vector<LiteralOffset> offsets = this.collectSensitiveLiteralOffsets(from.statement(), (Set<String>)extractedParamNames);
        Set<String> sensitiveParams = this.collectSensitiveParameterNames((Seq<Parameter>)parameters, (Set<String>)extractedParamNames);
        return from.withObfuscationMetadata(new ObfuscationMetadata(offsets, sensitiveParams));
    }

    private Vector<LiteralOffset> collectSensitiveLiteralOffsets(Statement statement, Set<String> extractedParamNames) {
        return (Vector)((SeqLike)((SeqLike)statement.folder().treeFold((Object)package$.MODULE$.Vector().empty(), (PartialFunction)new scala.Serializable(extractedParamNames){
            public static final long serialVersionUID = 0L;
            private final Set extractedParamNames$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof SensitiveLiteral) {
                    SensitiveLiteral sensitiveLiteral = (SensitiveLiteral)A1;
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Foldable.SkipChildren(acc.$colon$plus((Object)new LiteralOffset(sensitiveLiteral.position().offset(), sensitiveLiteral.position().line(), sensitiveLiteral.literalLength()), Vector$.MODULE$.canBuildFrom()));
                } else {
                    SensitiveAutoParameter sensitiveAutoParameter;
                    intersect = A1 instanceof SensitiveAutoParameter && this.extractedParamNames$1.contains((Object)(sensitiveAutoParameter = (SensitiveAutoParameter)A1).name()) ? (Function1 & Serializable & scala.Serializable)acc -> new Foldable.SkipChildren(acc.$colon$plus((Object)new LiteralOffset(sensitiveAutoParameter.position().offset(), sensitiveAutoParameter.position().line(), (Option)None$.MODULE$), Vector$.MODULE$.canBuildFrom())) : function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(Object x1) {
                SensitiveAutoParameter sensitiveAutoParameter;
                Object object = x1;
                boolean bl = object instanceof SensitiveLiteral ? true : object instanceof SensitiveAutoParameter && this.extractedParamNames$1.contains((Object)(sensitiveAutoParameter = (SensitiveAutoParameter)object).name());
                return bl;
            }
            {
                this.extractedParamNames$1 = extractedParamNames$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.SensitiveLiteral scala.collection.immutable.Vector ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.SensitiveAutoParameter scala.collection.immutable.Vector )}, serializedLambda);
            }
        })).distinct()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.start(0)), (Ordering)Ordering.Int$.MODULE$);
    }

    private Set<String> collectSensitiveParameterNames(Seq<Parameter> queryParams, Set<String> extractedParamNames) {
        return (Set)((TraversableOnce)Foldable$.MODULE$.FoldableAny(queryParams).folder().findAllByClass(ClassTag$.MODULE$.apply(SensitiveParameter.class)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus(extractedParamNames);
    }

    public String productPrefix() {
        return "ObfuscationMetadataCollection";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ObfuscationMetadataCollection$;
    }

    public int hashCode() {
        return 1152578288;
    }

    public String toString() {
        return "ObfuscationMetadataCollection";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ObfuscationMetadataCollection$() {
        MODULE$ = this;
        Transformer.$init$(this);
        Phase.$init$(this);
        Product.$init$((Product)this);
    }
}

