/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.neo4j.util.concurrent.AsyncEvent;
import org.neo4j.util.concurrent.AsyncEventSender;
import org.neo4j.util.concurrent.BinaryLatch;

public class AsyncEvents<T extends AsyncEvent>
implements AsyncEventSender<T>,
Runnable {
    private static final AtomicReferenceFieldUpdater<AsyncEvents, AsyncEvent> STACK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AsyncEvents.class, AsyncEvent.class, "stack");
    private static final Sentinel END_SENTINEL = new Sentinel("END");
    private static final Sentinel SHUTDOWN_SENTINEL = new Sentinel("SHUTDOWN");
    private final Consumer<T> eventConsumer;
    private final Monitor monitor;
    private final BinaryLatch startupLatch;
    private final BinaryLatch shutdownLatch;
    private volatile AsyncEvent stack;
    private volatile Thread backgroundThread;
    private volatile boolean shutdown;

    public AsyncEvents(Consumer<T> eventConsumer, Monitor monitor) {
        this.eventConsumer = eventConsumer;
        this.monitor = monitor;
        this.startupLatch = new BinaryLatch();
        this.shutdownLatch = new BinaryLatch();
        this.stack = END_SENTINEL;
    }

    @Override
    public void send(T event) {
        AsyncEvent prev = STACK_UPDATER.getAndSet(this, (AsyncEvent)event);
        assert (prev != null);
        ((AsyncEvent)event).next = prev;
        if (prev == END_SENTINEL) {
            LockSupport.unpark(this.backgroundThread);
        } else if (prev == SHUTDOWN_SENTINEL) {
            AsyncEvent events = STACK_UPDATER.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events);
        }
    }

    @Override
    public void run() {
        assert (this.backgroundThread == null) : "A thread is already running " + String.valueOf(this.backgroundThread);
        this.backgroundThread = Thread.currentThread();
        this.startupLatch.release();
        try {
            AsyncEvent events;
            do {
                events = STACK_UPDATER.getAndSet(this, END_SENTINEL);
                this.process(events);
                if (this.stack != END_SENTINEL || this.shutdown) continue;
                LockSupport.park(this);
            } while (!this.shutdown);
            events = STACK_UPDATER.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events);
        }
        finally {
            this.backgroundThread = null;
            this.shutdownLatch.release();
        }
    }

    private void process(AsyncEvent events) {
        events = this.reverseAndStripEndMark(events);
        while (events != null) {
            AsyncEvent event = events;
            this.eventConsumer.accept(event);
            events = events.next;
        }
    }

    private AsyncEvent reverseAndStripEndMark(AsyncEvent events) {
        AsyncEvent result = null;
        long count = 0L;
        while (events != END_SENTINEL && events != SHUTDOWN_SENTINEL) {
            AsyncEvent next;
            while ((next = events.next) == null) {
            }
            events.next = result;
            result = events;
            events = next;
            ++count;
        }
        if (count > 0L) {
            this.monitor.eventCount(count);
        }
        return result;
    }

    public void shutdown() {
        assert (!this.shutdown) : "Already shut down";
        this.shutdown = true;
        LockSupport.unpark(this.backgroundThread);
    }

    public void awaitStartup() {
        this.startupLatch.await();
    }

    public void awaitTermination() {
        this.shutdownLatch.await();
    }

    private static class Sentinel
    extends AsyncEvent {
        private final String str;

        Sentinel(String identifier) {
            this.str = "AsyncEvent/Sentinel[" + identifier + "]";
        }

        public String toString() {
            return this.str;
        }
    }

    public static interface Monitor {
        public static final Monitor NONE = count -> {};

        public void eventCount(long var1);
    }
}

