/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.packstream;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV1;
import org.neo4j.bolt.packstream.PackInput;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackStream;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public class Neo4jPackV2
extends Neo4jPackV1 {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Neo4jPackV2.class);
    public static final long VERSION = 2L;
    public static final byte POINT_2D = 88;
    public static final int POINT_2D_SIZE = 3;
    public static final byte POINT_3D = 89;
    public static final int POINT_3D_SIZE = 4;
    public static final byte DATE = 68;
    public static final int DATE_SIZE = 1;
    public static final byte TIME = 84;
    public static final int TIME_SIZE = 2;
    public static final byte LOCAL_TIME = 116;
    public static final int LOCAL_TIME_SIZE = 1;
    public static final byte LOCAL_DATE_TIME = 100;
    public static final int LOCAL_DATE_TIME_SIZE = 2;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET = 70;
    public static final int DATE_TIME_WITH_ZONE_OFFSET_SIZE = 3;
    public static final byte DATE_TIME_WITH_ZONE_NAME = 102;
    public static final int DATE_TIME_WITH_ZONE_NAME_SIZE = 3;
    public static final byte DURATION = 69;
    public static final int DURATION_SIZE = 4;

    @Override
    public Neo4jPack.Packer newPacker(PackOutput output) {
        return new PackerV2(output);
    }

    @Override
    public Neo4jPack.Unpacker newUnpacker(PackInput input) {
        return new UnpackerV2(input);
    }

    @Override
    public long version() {
        return 2L;
    }

    protected static class UnpackerV2
    extends Neo4jPackV1.UnpackerV1 {
        UnpackerV2(PackInput input) {
            super(input);
        }

        @Override
        protected AnyValue unpackStruct(char signature, long size) throws IOException {
            try {
                switch (signature) {
                    case 'X': {
                        UnpackerV2.ensureCorrectStructSize(StructType.POINT_2D, 3, size);
                        return this.unpackPoint2D();
                    }
                    case 'Y': {
                        UnpackerV2.ensureCorrectStructSize(StructType.POINT_3D, 4, size);
                        return this.unpackPoint3D();
                    }
                    case 'E': {
                        UnpackerV2.ensureCorrectStructSize(StructType.DURATION, 4, size);
                        return this.unpackDuration();
                    }
                    case 'D': {
                        UnpackerV2.ensureCorrectStructSize(StructType.DATE, 1, size);
                        return this.unpackDate();
                    }
                    case 't': {
                        UnpackerV2.ensureCorrectStructSize(StructType.LOCAL_TIME, 1, size);
                        return this.unpackLocalTime();
                    }
                    case 'T': {
                        UnpackerV2.ensureCorrectStructSize(StructType.TIME, 2, size);
                        return this.unpackTime();
                    }
                    case 'd': {
                        UnpackerV2.ensureCorrectStructSize(StructType.LOCAL_DATE_TIME, 2, size);
                        return this.unpackLocalDateTime();
                    }
                    case 'F': {
                        UnpackerV2.ensureCorrectStructSize(StructType.DATE_TIME_WITH_ZONE_OFFSET, 3, size);
                        return this.unpackDateTimeWithZoneOffset();
                    }
                    case 'f': {
                        UnpackerV2.ensureCorrectStructSize(StructType.DATE_TIME_WITH_ZONE_NAME, 3, size);
                        return this.unpackDateTimeWithZoneName();
                    }
                }
                return super.unpackStruct(signature, size);
            }
            catch (BoltIOException | PackStream.PackStreamException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                StructType type = StructType.valueOf(signature);
                if (type != null) {
                    throw new BoltIOException((Status)Status.Statement.TypeError, String.format("Unable to construct %s value: `%s`", type.description(), ex.getMessage()), ex);
                }
                throw ex;
            }
        }

        protected PointValue unpackPoint2D() throws IOException {
            int crsCode = this.unpackInteger();
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsCode);
            double[] coordinates = new double[]{this.unpackDouble(), this.unpackDouble()};
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
        }

        protected PointValue unpackPoint3D() throws IOException {
            int crsCode = this.unpackInteger();
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsCode);
            double[] coordinates = new double[]{this.unpackDouble(), this.unpackDouble(), this.unpackDouble()};
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
        }

        protected DurationValue unpackDuration() throws IOException {
            long months = this.unpackLong();
            long days = this.unpackLong();
            long seconds = this.unpackLong();
            long nanos = this.unpackInteger();
            return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
        }

        protected DateValue unpackDate() throws IOException {
            long epochDay = this.unpackLong();
            return DateValue.epochDate((long)epochDay);
        }

        protected LocalTimeValue unpackLocalTime() throws IOException {
            long nanoOfDay = this.unpackLong();
            return LocalTimeValue.localTime((long)nanoOfDay);
        }

        protected TimeValue unpackTime() throws IOException {
            long nanosOfDayLocal = this.unpackLong();
            int offsetSeconds = this.unpackInteger();
            return TimeValue.time((long)TemporalUtil.nanosOfDayToUTC((long)nanosOfDayLocal, (int)offsetSeconds), (ZoneOffset)ZoneOffset.ofTotalSeconds(offsetSeconds));
        }

        protected LocalDateTimeValue unpackLocalDateTime() throws IOException {
            long epochSecond = this.unpackLong();
            long nano = this.unpackLong();
            return LocalDateTimeValue.localDateTime((long)epochSecond, (long)nano);
        }

        protected DateTimeValue unpackDateTimeWithZoneOffset() throws IOException {
            long epochSecondLocal = this.unpackLong();
            long nano = this.unpackLong();
            int offsetSeconds = this.unpackInteger();
            return DateTimeValue.datetime((ZonedDateTime)UnpackerV2.newZonedDateTime(epochSecondLocal, nano, ZoneOffset.ofTotalSeconds(offsetSeconds)));
        }

        protected DateTimeValue unpackDateTimeWithZoneName() throws IOException {
            long epochSecondLocal = this.unpackLong();
            long nano = this.unpackLong();
            String zoneId = this.unpackString();
            return DateTimeValue.datetime((ZonedDateTime)UnpackerV2.newZonedDateTime(epochSecondLocal, nano, ZoneId.of(zoneId)));
        }

        protected static ZonedDateTime newZonedDateTime(long epochSecondLocal, long nano, ZoneId zoneId) {
            Instant instant = Instant.ofEpochSecond(epochSecondLocal, nano);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
    }

    protected static class PackerV2
    extends Neo4jPackV1.PackerV1 {
        PackerV2(PackOutput output) {
            super(output);
        }

        @Override
        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
            if (coordinate.length == 2) {
                this.packStructHeader(3, (byte)88);
                this.pack(crs.getCode());
                this.pack(coordinate[0]);
                this.pack(coordinate[1]);
            } else if (coordinate.length == 3) {
                this.packStructHeader(4, (byte)89);
                this.pack(crs.getCode());
                this.pack(coordinate[0]);
                this.pack(coordinate[1]);
                this.pack(coordinate[2]);
            } else {
                throw new IllegalArgumentException("Point with 2D or 3D coordinate expected, got crs=" + String.valueOf(crs) + ", coordinate=" + Arrays.toString(coordinate));
            }
        }

        @Override
        public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
            this.packStructHeader(4, (byte)69);
            this.pack(months);
            this.pack(days);
            this.pack(seconds);
            this.pack(nanos);
        }

        @Override
        public void writeDate(LocalDate localDate) throws IOException {
            long epochDay = localDate.toEpochDay();
            this.packStructHeader(1, (byte)68);
            this.pack(epochDay);
        }

        @Override
        public void writeLocalTime(LocalTime localTime) throws IOException {
            long nanoOfDay = localTime.toNanoOfDay();
            this.packStructHeader(1, (byte)116);
            this.pack(nanoOfDay);
        }

        @Override
        public void writeTime(OffsetTime offsetTime) throws IOException {
            long nanosOfDayLocal = offsetTime.toLocalTime().toNanoOfDay();
            int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
            this.packStructHeader(2, (byte)84);
            this.pack(nanosOfDayLocal);
            this.pack(offsetSeconds);
        }

        @Override
        public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
            long epochSecond = localDateTime.toEpochSecond(ZoneOffset.UTC);
            int nano = localDateTime.getNano();
            this.packStructHeader(2, (byte)100);
            this.pack(epochSecond);
            this.pack(nano);
        }

        @Override
        public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
            long epochSecondLocal = zonedDateTime.toLocalDateTime().toEpochSecond(ZoneOffset.UTC);
            int nano = zonedDateTime.getNano();
            ZoneId zone = zonedDateTime.getZone();
            if (zone instanceof ZoneOffset) {
                int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                this.packStructHeader(3, (byte)70);
                this.pack(epochSecondLocal);
                this.pack(nano);
                this.pack(offsetSeconds);
            } else {
                String zoneId = zone.getId();
                this.packStructHeader(3, (byte)102);
                this.pack(epochSecondLocal);
                this.pack(nano);
                this.pack(zoneId);
            }
        }
    }
}

