/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3;

import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.AbstractBoltProtocol;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.v3.messaging.BoltRequestMessageReaderV3;
import org.neo4j.bolt.v3.messaging.BoltResponseMessageWriterV3;
import org.neo4j.configuration.Config;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;

public class BoltProtocolV3
extends AbstractBoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(3, 0);

    public BoltProtocolV3(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, Config config, LogService logging, TransportThrottleGroup throttleGroup, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        super(channel, connectionFactory, stateMachineFactory, config, logging, throttleGroup, channelProtector, memoryTracker);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected BoltRequestMessageReader createMessageReader(BoltConnection connection, BoltResponseMessageWriter messageWriter, BookmarksParser parser, LogService logging, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(BoltRequestMessageReaderV3.SHALLOW_SIZE);
        return new BoltRequestMessageReaderV3(connection, messageWriter, channelProtector, logging);
    }

    @Override
    protected BoltResponseMessageWriter createMessageWriter(Neo4jPack neo4jPack, LogService logging, MemoryTracker memoryTracker) {
        PackOutput output = this.createPackOutput(memoryTracker);
        memoryTracker.allocateHeap(BoltResponseMessageWriterV3.SHALLOW_SIZE);
        return new BoltResponseMessageWriterV3(neo4jPack, output, logging);
    }
}

