/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.v3.messaging.request.TransactionInitiatingMessage;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class RunMessage
extends TransactionInitiatingMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final MapValue params;

    public RunMessage(String statement) {
        this(statement, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params) {
        this(statement, params, VirtualValues.EMPTY_MAP, List.of(), null, AccessMode.WRITE, Map.of());
    }

    public RunMessage(String statement, MapValue params, MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) {
        super(meta, bookmarks, txTimeout, accessMode, txMetadata);
        this.statement = statement;
        this.params = params;
    }

    public String statement() {
        return this.statement;
    }

    public MapValue params() {
        return this.params;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            RunMessage that = (RunMessage)o;
            return Objects.equals(this.statement, that.statement) && Objects.equals(this.params, that.params);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.params, this.meta());
    }

    public String toString() {
        return "RUN " + this.statement + " " + String.valueOf(this.params) + " " + String.valueOf(this.meta());
    }
}

