/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.exceptions.KernelException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class TransactionReadyState
extends FailSafeBoltStateMachineState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionReadyState.class);
    private BoltStateMachineState streamingState;
    private BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message instanceof RunMessage) {
            return this.processRunMessage((RunMessage)message, context);
        }
        if (message instanceof CommitMessage) {
            return this.processCommitMessage(context);
        }
        if (message instanceof RollbackMessage) {
            return this.processRollbackMessage(context);
        }
        return null;
    }

    @Override
    public String name() {
        return "TX_READY";
    }

    public void setTransactionStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws KernelException, TransactionNotFoundException {
        long start = context.clock().millis();
        StatementMetadata metadata = context.getTransactionManager().runQuery(context.connectionState().getCurrentTransactionId(), message.statement(), message.params());
        long end = context.clock().millis();
        context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])metadata.fieldNames()));
        context.connectionState().onMetadata("t_first", (AnyValue)Values.longValue((long)(end - start)));
        return this.streamingState;
    }

    private BoltStateMachineState processCommitMessage(StateMachineContext context) throws KernelException, TransactionNotFoundException {
        Bookmark bookmark = context.getTransactionManager().commit(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        bookmark.attachTo(context.connectionState());
        return this.readyState;
    }

    private BoltStateMachineState processRollbackMessage(StateMachineContext context) throws TransactionNotFoundException {
        context.getTransactionManager().rollback(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        return this.readyState;
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

