/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.Objects;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractTransactionStatementSPIProvider;
import org.neo4j.bolt.v4.runtime.TransactionStateMachineV4SPI;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;

public class TransactionStateMachineSPIProviderV4
extends AbstractTransactionStatementSPIProvider {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionStateMachineSPIProviderV4.class);

    public TransactionStateMachineSPIProviderV4(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, BoltChannel boltChannel, SystemNanoClock clock, MemoryTracker memoryTracker) {
        super(boltGraphDatabaseManagementServiceSPI, boltChannel, clock, memoryTracker);
    }

    @Override
    protected String selectDatabaseName(String databaseName) {
        return Objects.equals(databaseName, "") ? this.boltChannel.defaultDatabase() : databaseName;
    }

    @Override
    protected TransactionStateMachineSPI newTransactionStateMachineSPI(BoltGraphDatabaseServiceSPI activeBoltGraphDatabaseServiceSPI, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) {
        this.memoryTracker.allocateHeap(TransactionStateMachineV4SPI.SHALLOW_SIZE);
        return new TransactionStateMachineV4SPI(activeBoltGraphDatabaseServiceSPI, this.boltChannel, this.clock, resourceReleaseManager, transactionId);
    }
}

