/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.log4j.Log4jPluginLoadingWorkaround;
import org.neo4j.logging.log4j.Neo4jConfiguration;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.logging.shaded.log4j.Level;
import org.neo4j.logging.shaded.log4j.core.Logger;
import org.neo4j.logging.shaded.log4j.core.LoggerContext;
import org.neo4j.logging.shaded.log4j.core.appender.AbstractAppender;
import org.neo4j.logging.shaded.log4j.core.appender.AbstractOutputStreamAppender;
import org.neo4j.logging.shaded.log4j.core.appender.OutputStreamAppender;
import org.neo4j.logging.shaded.log4j.core.appender.RollingFileAppender;
import org.neo4j.logging.shaded.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.neo4j.logging.shaded.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.neo4j.logging.shaded.log4j.core.config.LoggerConfig;
import org.neo4j.logging.shaded.log4j.core.layout.PatternLayout;

public class RotatingLogFileWriter
implements Closeable {
    private static final String APPENDER_NAME = "rotatingWriter";
    private final Logger log;
    private final Neo4jLoggerContext ctx;

    public RotatingLogFileWriter(FileSystemAbstraction fs, Path logPath, long rotationThreshold, int maxArchives, String fileSuffix, String header) {
        this.ctx = RotatingLogFileWriter.setupLogFile(fs, logPath, rotationThreshold, maxArchives, fileSuffix, header);
        this.log = this.ctx.getLogger("");
    }

    public void printf(String pattern, Object ... params) {
        this.log.printf(Level.DEBUG, pattern, params);
    }

    @Override
    public void close() throws IOException {
        this.ctx.close();
    }

    private static Neo4jLoggerContext setupLogFile(FileSystemAbstraction fileSystemAbstraction, Path logPath, long rotationThreshold, int maxArchives, String fileSuffix, String header) {
        try {
            AbstractOutputStreamAppender appender;
            OutputStream additionalCloseable = null;
            Neo4jConfiguration configuration = new Neo4jConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration(configuration).withHeader(header).build();
            if (fileSystemAbstraction instanceof DefaultFileSystemAbstraction) {
                appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)RollingFileAppender.newBuilder()).setName("rotatingWriter." + logPath.getFileName().toString())).setLayout(layout)).withFileName(logPath.toString())).withFilePattern(String.valueOf(logPath) + ".%i" + fileSuffix)).withPolicy(SizeBasedTriggeringPolicy.createPolicy(String.valueOf(rotationThreshold)))).withStrategy(DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(maxArchives)).withFileIndex("min").build())).build();
            } else {
                OutputStream outputStream;
                fileSystemAbstraction.mkdirs(logPath.getParent());
                additionalCloseable = outputStream = fileSystemAbstraction.openAsOutputStream(logPath, true);
                appender = ((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)((AbstractAppender.Builder)OutputStreamAppender.newBuilder()).setName("rotatingWriter." + logPath.getFileName().toString())).setLayout(layout)).setTarget(outputStream)).build();
            }
            appender.start();
            configuration.addAppender(appender);
            LoggerConfig rootLogger = configuration.getRootLogger();
            rootLogger.addAppender(appender, null, null);
            rootLogger.setLevel(Level.DEBUG);
            LoggerContext context = new LoggerContext("loggercontext");
            context.setConfiguration(configuration);
            return new Neo4jLoggerContext(context, additionalCloseable);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        Log4jPluginLoadingWorkaround.doLog4jPluginLoadingWorkaround();
    }
}

