/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.transport.configuration.EpollConfigurationProvider;
import org.neo4j.bolt.transport.configuration.NioConfigurationProvider;
import org.neo4j.bolt.transport.configuration.ServerConfigurationProvider;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class NettyServer
extends LifecycleAdapter {
    private final ServerConfigurationProvider configurationProvider;
    private final ProtocolInitializer externalInitializer;
    private final Config config;
    private final ProtocolInitializer internalInitializer;
    private final ThreadFactory tf;
    private final ProtocolInitializer loopbackInitializer;
    private final ConnectorPortRegister portRegister;
    private final Log userLog;
    private final Log internalLog;
    private EventLoopGroup eventLoopGroup;
    private final List<Channel> serverChannels;

    public NettyServer(ThreadFactory tf, ProtocolInitializer externalInitializer, ProtocolInitializer loopbackInitializer, ConnectorPortRegister connectorRegister, LogService logService, Config config) {
        this.externalInitializer = externalInitializer;
        this.config = config;
        this.internalInitializer = null;
        this.loopbackInitializer = loopbackInitializer;
        this.tf = tf;
        this.portRegister = connectorRegister;
        this.userLog = logService.getUserLog(BoltServer.class);
        this.internalLog = logService.getUserLog(((Object)((Object)this)).getClass());
        this.configurationProvider = NettyServer.createConfigurationProvider(config);
        this.serverChannels = new ArrayList<Channel>();
    }

    public NettyServer(ThreadFactory tf, ProtocolInitializer externalInitializer, ProtocolInitializer internalInitializer, ProtocolInitializer loopbackInitializer, ConnectorPortRegister connectorRegister, LogService logService, Config config) {
        this.externalInitializer = externalInitializer;
        this.config = config;
        this.internalInitializer = internalInitializer;
        this.loopbackInitializer = loopbackInitializer;
        this.tf = tf;
        this.portRegister = connectorRegister;
        this.userLog = logService.getUserLog(BoltServer.class);
        this.internalLog = logService.getUserLog(((Object)((Object)this)).getClass());
        this.configurationProvider = NettyServer.createConfigurationProvider(config);
        this.serverChannels = new ArrayList<Channel>();
    }

    public void init() {
        this.eventLoopGroup = this.configurationProvider.createEventLoopGroup(this.tf);
    }

    public void start() throws Exception {
        int port;
        String host;
        if (this.externalInitializer != null) {
            InetSocketAddress externalLocalAddress = (InetSocketAddress)this.configureInitializer(this.externalInitializer);
            this.portRegister.register("bolt", externalLocalAddress);
            host = externalLocalAddress.getHostName();
            port = externalLocalAddress.getPort();
            this.userLog.info("Bolt enabled on %s.", new Object[]{SocketAddress.format((String)host, (int)port)});
        }
        if (this.internalInitializer != null) {
            InetSocketAddress internalLocalAddress = (InetSocketAddress)this.configureInitializer(this.internalInitializer);
            this.portRegister.register("bolt-internal", internalLocalAddress);
            host = internalLocalAddress.getHostName();
            port = internalLocalAddress.getPort();
            this.userLog.info("Bolt (Routing) enabled on %s.", new Object[]{SocketAddress.format((String)host, (int)port)});
        }
        if (this.loopbackInitializer != null) {
            java.net.SocketAddress loopbackLocalAddress = this.configureInitializer(this.loopbackInitializer);
            this.userLog.info("Bolt (loopback) enabled on file %s", new Object[]{loopbackLocalAddress});
        }
    }

    private java.net.SocketAddress configureInitializer(ProtocolInitializer protocolInitializer) throws Exception {
        try {
            Channel externalChannel = this.bind(this.configurationProvider, protocolInitializer);
            this.serverChannels.add(externalChannel);
            return externalChannel.localAddress();
        }
        catch (Throwable e) {
            throw new PortBindException(protocolInitializer.address(), e);
        }
    }

    public void stop() throws Exception {
        ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{this::unregisterListenAddresses, this::closeChannels});
    }

    public void shutdown() {
        this.shutdownEventLoopGroup();
        if (this.loopbackInitializer != null) {
            try {
                Files.deleteIfExists(Path.of(((DomainSocketAddress)this.loopbackInitializer.address()).path(), new String[0]));
            }
            catch (IOException e) {
                this.internalLog.warn("Failed to delete loopback domain socket file", (Throwable)e);
            }
        }
    }

    private Channel bind(ServerConfigurationProvider configurationProvider, ProtocolInitializer protocolInitializer) throws InterruptedException {
        ServerBootstrap serverBootstrap = this.createServerBootstrap(configurationProvider, protocolInitializer);
        java.net.SocketAddress address = protocolInitializer.address();
        return serverBootstrap.bind(address).sync().channel();
    }

    private ServerBootstrap createServerBootstrap(ServerConfigurationProvider configurationProvider, ProtocolInitializer protocolInitializer) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.eventLoopGroup).channel(configurationProvider.getChannelClass(protocolInitializer.address()))).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childHandler(protocolInitializer.channelInitializer());
        if (!(protocolInitializer.address() instanceof DomainSocketAddress)) {
            serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)this.config.get(BoltConnectorInternalSettings.tcp_keep_alive) != false ? Boolean.TRUE : Boolean.FALSE));
        }
        return serverBootstrap;
    }

    private static ServerConfigurationProvider createConfigurationProvider(Config config) {
        boolean useEpoll = (Boolean)config.get(GraphDatabaseInternalSettings.netty_server_use_epoll) != false && Epoll.isAvailable();
        return useEpoll ? EpollConfigurationProvider.INSTANCE : NioConfigurationProvider.INSTANCE;
    }

    private void unregisterListenAddresses() {
        this.portRegister.deregister("bolt");
        this.portRegister.deregister("bolt-internal");
    }

    private void closeChannels() {
        this.internalLog.debug("Closing server channels");
        for (Channel channel : this.serverChannels) {
            try {
                channel.close().syncUninterruptibly();
            }
            catch (Throwable t) {
                this.internalLog.warn("Failed to close channel " + String.valueOf(channel), t);
            }
        }
        this.internalLog.debug("Server channels closed");
        this.serverChannels.clear();
    }

    private void shutdownEventLoopGroup() {
        if (this.eventLoopGroup != null) {
            try {
                this.internalLog.debug("Shutting down event loop group");
                this.eventLoopGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS).syncUninterruptibly();
                this.internalLog.debug("Event loop group shut down");
            }
            catch (Throwable t) {
                this.internalLog.warn("Failed to shutdown event loop group", t);
            }
            this.eventLoopGroup = null;
        }
    }

    public static interface ProtocolInitializer {
        public ChannelInitializer<Channel> channelInitializer();

        public java.net.SocketAddress address();
    }
}

