/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Map;
import java.util.Objects;

public class DataPoint {
    @JsonPropertyDescription(value="Map of string key-value pairs providing additional context for the metric")
    private Map<String, String> tags;
    @JsonPropertyDescription(value="Double value representing the metric measurement")
    private final Double value;

    public DataPoint(Double value) {
        this.value = value;
    }

    public DataPoint(Integer value) {
        this.value = value.doubleValue();
    }

    public DataPoint(Long value) {
        this.value = value.doubleValue();
    }

    public DataPoint(Map<String, String> tags, Double value) {
        this.tags = tags;
        this.value = value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataPoint)) {
            return false;
        }
        DataPoint other = (DataPoint)o;
        if (!Objects.equals(this.tags, other.tags)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

