/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.model;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.neo4j.fleetmanagement.common.ValuesDocumentation;
import com.neo4j.fleetmanagement.procedures.Neo4jConfigNamesSupplier;
import java.util.Map;

@JsonClassDescription(value="Message sent from the plugin to the Fleet Management service containing neo4j configuration data.")
public class Neo4jConfigMessage {
    @JsonPropertyDescription(value="Unix timestamp in milliseconds when the message was created")
    public long timestamp = System.currentTimeMillis();
    @JsonProperty(value="project_id")
    @JsonPropertyDescription(value="Identifier for the project")
    public String projectId;
    @JsonProperty(value="dbms_id")
    @JsonPropertyDescription(value="Unique identifier for the DBMS")
    public String dbmsId;
    @JsonProperty(value="server_id")
    @JsonPropertyDescription(value="Unique identifier for the server")
    public String serverId;
    @JsonProperty(value="neo4j_config")
    @JsonPropertyDescription(value="Map of neo4j config names to config values. Values are dynamically populated from the Fleet Management server.")
    @ValuesDocumentation(valueSupplier=Neo4jConfigNamesSupplier.class)
    public Map<String, Object> neo4jConfig;
}

