/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class State {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Boolean active = null;
    private boolean connected;
    private boolean rotatingToken;
    private String connectionMessage;
    private boolean topologyInitialized;
    public static final String ACTIVE_CHANGE = "active";
    public static final String CONNECTED_CHANGE = "connected";
    public static final String ROTATING_TOKEN_CHANGE = "rotatingToken";
    public static final String TOPOLOGY_INITIALIZED = "topologyInitialized";
    private static State instance;

    public static synchronized State getInstance() {
        if (instance == null) {
            instance = new State();
        }
        return instance;
    }

    private State() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void setActive(boolean active) {
        this.changeSupport.firePropertyChange(ACTIVE_CHANGE, this.active, (Object)active);
        this.active = active;
        if (!active) {
            this.connectionMessage = null;
        }
    }

    private void setConnected(boolean connected) {
        this.changeSupport.firePropertyChange(CONNECTED_CHANGE, this.connected, connected);
        this.connected = connected;
        if (connected) {
            this.connectionMessage = null;
        }
    }

    public void setConnected() {
        this.connectionMessage = null;
        this.setConnected(true);
    }

    public void setDisconnected(String errorMessage) {
        this.connectionMessage = errorMessage;
        this.setConnected(false);
        this.setTopologyInitialized(false);
    }

    public void setConnectionMessage(String connectionMessage) {
        this.connectionMessage = connectionMessage;
    }

    public void setRotatingToken(boolean rotatingToken) {
        this.changeSupport.firePropertyChange(ROTATING_TOKEN_CHANGE, this.rotatingToken, rotatingToken);
        this.rotatingToken = rotatingToken;
    }

    public void setTopologyInitialized(boolean isTopologyInitialized) {
        this.changeSupport.firePropertyChange(TOPOLOGY_INITIALIZED, this.topologyInitialized, isTopologyInitialized);
        this.topologyInitialized = isTopologyInitialized;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isActive() {
        if (this.active == null) {
            return false;
        }
        return this.active;
    }

    public boolean isRotatingToken() {
        return this.rotatingToken;
    }

    public boolean isTopologyInitialized() {
        return this.topologyInitialized;
    }

    public String getConnectionMessage() {
        return this.connectionMessage;
    }
}

