/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl.config;

import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.SslSystemInternalSettings;
import org.neo4j.configuration.SslSystemSettings;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.string.SecureString;

public class SslPolicyLoader {
    private static final DirectoryStream.Filter<Path> ALL_FILES = path -> true;
    private static final DirectoryStream.Filter<Path> SKIP_DOT_FILES = path -> !path.getFileName().toString().startsWith(".");
    private final Map<SslPolicyScope, SslPolicy> policies = new ConcurrentHashMap<SslPolicyScope, SslPolicy>();
    private final Config config;
    private final SslProvider sslProvider;
    private final LogProvider logProvider;
    private final Log log;
    private final boolean skipDotFiles;

    private SslPolicyLoader(Config config, LogProvider logProvider) {
        this.config = config;
        this.skipDotFiles = (Boolean)config.get(SslSystemInternalSettings.ignore_dotfiles);
        this.sslProvider = (SslProvider)config.get(SslSystemSettings.netty_ssl_provider);
        this.logProvider = logProvider;
        this.log = logProvider.getLog(SslPolicyLoader.class);
    }

    public static SslPolicyLoader create(Config config, LogProvider logProvider) {
        SslPolicyLoader policyFactory = new SslPolicyLoader(config, logProvider);
        policyFactory.load();
        return policyFactory;
    }

    public SslPolicy getPolicy(SslPolicyScope scope) {
        if (scope == null) {
            return null;
        }
        SslPolicy sslPolicy = this.policies.get(scope);
        if (sslPolicy == null) {
            throw new IllegalArgumentException(String.format("Cannot find enabled SSL policy with name '%s' in the configuration", scope));
        }
        return sslPolicy;
    }

    public boolean hasPolicyForSource(SslPolicyScope scope) {
        return this.policies.containsKey(scope);
    }

    private void load() {
        this.config.getGroups(SslPolicyConfig.class).values().forEach(this::addPolicy);
        this.policies.forEach((scope, sslPolicy) -> this.log.info(String.format("Loaded SSL policy '%s' = %s", scope.name(), sslPolicy)));
    }

    private void addPolicy(SslPolicyConfig policyConfig) {
        SslPolicy policy;
        SslPolicyScope scope;
        if (((Boolean)this.config.get(policyConfig.enabled)).booleanValue() && this.policies.put(scope = policyConfig.getScope(), policy = this.createSslPolicy(policyConfig)) != null) {
            throw new IllegalStateException("Can not have multiple SslPolicies configured for " + scope.name());
        }
    }

    private SslPolicy createSslPolicy(SslPolicyConfig policyConfig) {
        TrustManagerFactory trustManagerFactory;
        Path baseDirectory = (Path)this.config.get(policyConfig.base_directory);
        Path revokedCertificatesDir = (Path)this.config.get(policyConfig.revoked_dir);
        if (Files.notExists(baseDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Base directory '%s' for SSL policy with name '%s' does not exist.", baseDirectory, policyConfig.name()));
        }
        KeyAndChain keyAndChain = this.pemKeyAndChain(policyConfig);
        Collection<X509CRL> crls = SslPolicyLoader.getCRLs(revokedCertificatesDir, this.certificateFilenameFilter());
        try {
            trustManagerFactory = SslPolicyLoader.createTrustManagerFactory((Boolean)this.config.get(policyConfig.trust_all), crls, keyAndChain.trustStore);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create trust manager", e);
        }
        boolean verifyHostname = (Boolean)this.config.get(policyConfig.verify_hostname);
        ClientAuth clientAuth = (ClientAuth)this.config.get(policyConfig.client_auth);
        List tlsVersions = (List)this.config.get(policyConfig.tls_versions);
        List ciphers = (List)this.config.get(policyConfig.ciphers);
        return new SslPolicy(keyAndChain.privateKey, keyAndChain.keyCertChain, tlsVersions, ciphers, clientAuth, trustManagerFactory, this.sslProvider, verifyHostname, this.logProvider);
    }

    private KeyAndChain pemKeyAndChain(SslPolicyConfig policyConfig) {
        KeyStore trustStore;
        Path privateKeyFile = (Path)this.config.get(policyConfig.private_key);
        SecureString privateKeyPassword = (SecureString)this.config.get(policyConfig.private_key_password);
        Path trustedCertificatesDir = (Path)this.config.get(policyConfig.trusted_dir);
        ClientAuth clientAuth = (ClientAuth)this.config.get(policyConfig.client_auth);
        try {
            trustStore = this.createTrustStoreFromPem(trustedCertificatesDir, clientAuth);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create trust manager based on: " + String.valueOf(trustedCertificatesDir), e);
        }
        if (policyConfig.getScope().isClientOnly() && !Files.exists(privateKeyFile, new LinkOption[0])) {
            return new KeyAndChain(null, new X509Certificate[0], trustStore);
        }
        Path keyCertChainFile = (Path)this.config.get(policyConfig.public_certificate);
        PrivateKey privateKey = SslPolicyLoader.loadPrivateKey(privateKeyFile, privateKeyPassword);
        X509Certificate[] keyCertChain = SslPolicyLoader.loadCertificateChain(keyCertChainFile);
        return new KeyAndChain(privateKey, keyCertChain, trustStore);
    }

    private static Collection<X509CRL> getCRLs(Path revokedCertificatesDir, DirectoryStream.Filter<Path> filter) {
        CertificateFactory certificateFactory;
        Path[] revocationFiles;
        if (Files.notExists(revokedCertificatesDir, new LinkOption[0])) {
            return new ArrayList<X509CRL>();
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(revokedCertificatesDir, filter);){
            revocationFiles = (Path[])StreamSupport.stream(paths.spliterator(), false).toArray(Path[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not find or list files in revoked directory: %s", revokedCertificatesDir), e);
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not generated certificate factory", e);
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        for (Path crl : revocationFiles) {
            try (InputStream input = Files.newInputStream(crl, new OpenOption[0]);){
                crls.addAll(certificateFactory.generateCRLs(input));
            }
            catch (IOException | CRLException e) {
                throw new RuntimeException(String.format("Could not load CRL: %s", crl), e);
            }
        }
        return crls;
    }

    private static X509Certificate[] loadCertificateChain(Path keyCertChainFile) {
        try {
            return PkiUtils.loadCertificates(keyCertChainFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load public certificate chain: " + String.valueOf(keyCertChainFile), e);
        }
    }

    private static PrivateKey loadPrivateKey(Path privateKeyFile, SecureString privateKeyPassword) {
        String password = privateKeyPassword != null ? privateKeyPassword.getString() : null;
        try {
            return PkiUtils.loadPrivateKey(privateKeyFile, password);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key: " + String.valueOf(privateKeyFile) + (privateKeyPassword == null ? "" : " (using configured password)"), e);
        }
    }

    private static TrustManagerFactory createTrustManagerFactory(boolean trustAll, Collection<X509CRL> crls, KeyStore trustStore) throws Exception {
        if (trustAll) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (!crls.isEmpty()) {
            PKIXBuilderParameters pkixParamsBuilder = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            pkixParamsBuilder.setRevocationEnabled(true);
            pkixParamsBuilder.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
            trustManagerFactory.init(new CertPathTrustManagerParameters(pkixParamsBuilder));
        } else {
            trustManagerFactory.init(trustStore);
        }
        return trustManagerFactory;
    }

    /*
     * Exception decompiling
     */
    private KeyStore createTrustStoreFromPem(Path trustedCertificatesDir, ClientAuth clientAuth) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DirectoryStream.Filter<Path> certificateFilenameFilter() {
        return this.skipDotFiles ? SKIP_DOT_FILES : ALL_FILES;
    }

    private static /* synthetic */ Path[] lambda$createTrustStoreFromPem$4(int x$0) {
        return new Path[x$0];
    }

    private static final class KeyAndChain {
        final PrivateKey privateKey;
        final X509Certificate[] keyCertChain;
        final KeyStore trustStore;

        private KeyAndChain(PrivateKey privateKey, X509Certificate[] keyCertChain, KeyStore trustStore) {
            this.privateKey = privateKey;
            this.keyCertChain = keyCertChain;
            this.trustStore = trustStore;
        }
    }
}

