/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.LocalIntCounter;

public class RecordChanges<RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RecordChanges.class) + HeapEstimator.shallowSizeOfInstance(LocalIntCounter.class);
    public static final long CHANGE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RecordChange.class);
    private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> recordChanges;
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final MutableInt changeCounter;
    private final MemoryTracker memoryTracker;
    private final RecordAccess.LoadMonitor loadMonitor;
    private final StoreCursors storeCursors;

    public static <RECORD extends AbstractBaseRecord, ADDITIONAL> RecordChanges<RECORD, ADDITIONAL> create(RecordAccess.Loader<RECORD, ADDITIONAL> loader, MutableInt globalCounter, MemoryTracker memoryTracker, RecordAccess.LoadMonitor loadMonitor, StoreCursors storeCursors) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new RecordChanges<RECORD, ADDITIONAL>(loader, globalCounter, memoryTracker, loadMonitor, storeCursors);
    }

    private RecordChanges(RecordAccess.Loader<RECORD, ADDITIONAL> loader, MutableInt globalCounter, MemoryTracker memoryTracker, RecordAccess.LoadMonitor loadMonitor, StoreCursors storeCursors) {
        this.loader = loader;
        this.recordChanges = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
        this.changeCounter = new LocalIntCounter(globalCounter);
        this.memoryTracker = memoryTracker;
        this.loadMonitor = loadMonitor;
        this.storeCursors = storeCursors;
    }

    public String toString() {
        return "RecordChanges{recordChanges=" + String.valueOf(this.recordChanges) + "}";
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return (RecordAccess.RecordProxy)this.recordChanges.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData, RecordLoad load) {
        RecordAccess.RecordProxy result = (RecordAccess.RecordProxy)this.recordChanges.get(key);
        if (result == null) {
            RECORD record = this.loader.load(key, additionalData, load, this.memoryTracker);
            this.memoryTracker.allocateHeap(CHANGE_SHALLOW_SIZE);
            result = new RecordChange(this, key, record, false, additionalData);
        }
        return result;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData, CursorContext cursorContext) {
        this.memoryTracker.allocateHeap(CHANGE_SHALLOW_SIZE);
        RecordChange recordChange = new RecordChange(this, key, record, false, additionalData);
        this.recordChanges.put(key, (Object)recordChange);
        return recordChange;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData, CursorContext cursorContext) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData, this.memoryTracker);
        this.memoryTracker.allocateHeap(CHANGE_SHALLOW_SIZE);
        RecordChange change = new RecordChange(this, key, record, true, additionalData);
        this.recordChanges.put(key, (Object)change);
        return change;
    }

    @Override
    public Collection<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> changes() {
        return this.recordChanges.values();
    }

    private class RecordChange
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final ADDITIONAL additionalData;
        private final RECORD record;
        private final boolean created;
        private final long key;
        private RECORD before;
        private boolean changed;
        final /* synthetic */ RecordChanges this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private RecordChange(long record, RECORD additionalData, boolean bl, ADDITIONAL ADDITIONAL) {
            void created;
            void key;
            this.this$0 = (RecordChanges)l;
            this.key = key;
            this.record = record;
            this.created = created;
            this.additionalData = additionalData;
        }

        public String toString() {
            return "RecordChange{record=" + String.valueOf(this.record) + ",key=" + this.key + ",created=" + this.created + "}";
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy(this.this$0.storeCursors);
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                RecordAccess.RecordProxy previous = (RecordAccess.RecordProxy)this.this$0.recordChanges.put(this.key, (Object)this);
                if (previous == null || !previous.isChanged()) {
                    this.this$0.loadMonitor.markedAsChanged((AbstractBaseRecord)this.before);
                    this.this$0.changeCounter.increment();
                }
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy(StoreCursors storeCursors) {
            if (!this.created) {
                this.this$0.loader.ensureHeavy(this.record, storeCursors);
                if (this.before != null) {
                    this.this$0.loader.ensureHeavy(this.before, storeCursors);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy(this.this$0.storeCursors);
            return this.record;
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.this$0.loader.copy(this.record, this.this$0.memoryTracker);
            }
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

