/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.recordstorage.PropertyBasedSchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.SchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaStorage
implements SchemaRuleAccess {
    private final SchemaStore schemaStore;
    private final TokenHolders tokenHolders;
    private final KernelVersionRepository versionSupplier;

    public SchemaStorage(SchemaStore schemaStore, TokenHolders tokenHolders, KernelVersionRepository versionSupplier) {
        this.schemaStore = schemaStore;
        this.tokenHolders = tokenHolders;
        this.versionSupplier = versionSupplier;
    }

    @Override
    public long newRuleId(CursorContext cursorContext) {
        return this.schemaStore.nextId(cursorContext);
    }

    @Override
    public Iterable<SchemaRule> getAll(StoreCursors storeCursors) {
        return this.streamAllSchemaRules(false, storeCursors)::iterator;
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        SchemaRecord record = this.loadSchemaRecord(ruleId, storeCursors);
        return this.readSchemaRule(record, storeCursors);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).iterator();
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAllIgnoreMalformed(StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(true, storeCursors)).iterator();
    }

    @Override
    public Iterator<IndexDescriptor> tokenIndexes(StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(true, storeCursors)).filter(IndexRef::isTokenIndex).iterator();
    }

    @Override
    public IndexDescriptor[] indexGetForSchema(SchemaDescriptorSupplier supplier, StoreCursors storeCursors) {
        SchemaDescriptor schema = supplier.schema();
        return (IndexDescriptor[])SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).filter(rule -> rule.schema().equals(schema)).toArray(IndexDescriptor[]::new);
    }

    @Override
    public IndexDescriptor indexGetForName(String indexName, StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).filter(idx -> idx.getName().equals(indexName)).findAny().orElse(null);
    }

    @Override
    public ConstraintDescriptor constraintsGetSingle(ConstraintDescriptor descriptor, StoreCursors storeCursors) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        ConstraintDescriptor[] rules = (ConstraintDescriptor[])SchemaStorage.constraintRules(this.streamAllSchemaRules(false, storeCursors)).filter(descriptor::equals).toArray(ConstraintDescriptor[]::new);
        if (rules.length == 0) {
            throw new SchemaRuleNotFoundException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        if (rules.length > 1) {
            throw new DuplicateSchemaRuleException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        return rules[0];
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAllIgnoreMalformed(StoreCursors storeCursors) {
        return SchemaStorage.constraintRules(this.streamAllSchemaRules(true, storeCursors)).iterator();
    }

    @Override
    public SchemaRecordChangeTranslator getSchemaRecordChangeTranslator() {
        return new PropertyBasedSchemaRecordChangeTranslator(){

            @Override
            protected IntObjectMap<Value> asMap(SchemaRule rule) throws KernelException {
                return SchemaStore.convertSchemaRuleToMap(rule, SchemaStorage.this.tokenHolders);
            }

            @Override
            protected void setConstraintIndexOwnerProperty(long constraintId, IntObjectProcedure<Value> proc) throws KernelException {
                int propertyId = SchemaStore.getOwningConstraintPropertyKeyId(SchemaStorage.this.tokenHolders);
                proc.value(propertyId, (Object)Values.longValue((long)constraintId));
            }
        };
    }

    @Override
    public void writeSchemaRule(SchemaRule rule, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) throws KernelException {
        IntObjectMap<Value> protoProperties = SchemaStore.convertSchemaRuleToMap(rule, this.tokenHolders);
        PropertyStore propertyStore = this.schemaStore.propertyStore();
        ArrayList blocks = new ArrayList();
        protoProperties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            PropertyBlock block = new PropertyBlock();
            propertyStore.encodeValue(block, keyId, (Value)value, cursorContext, memoryTracker);
            blocks.add(block);
        });
        assert (!blocks.isEmpty()) : "Property blocks should have been produced for schema rule: " + String.valueOf(rule);
        long nextPropId = Record.NO_NEXT_PROPERTY.longValue();
        PropertyRecord currRecord = SchemaStorage.newInitialisedPropertyRecord(propertyStore, rule, cursorContext);
        try (PageCursor propertyCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
             PageCursor schemaCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR);){
            for (PropertyBlock block : blocks) {
                if (!currRecord.hasSpaceFor(block)) {
                    PropertyRecord nextRecord = SchemaStorage.newInitialisedPropertyRecord(propertyStore, rule, cursorContext);
                    SchemaStorage.linkAndWritePropertyRecord(propertyStore, currRecord, nextRecord.getId(), nextPropId, propertyCursor, cursorContext, storeCursors);
                    nextPropId = currRecord.getId();
                    currRecord = nextRecord;
                }
                currRecord.addPropertyBlock(block);
            }
            SchemaStorage.linkAndWritePropertyRecord(propertyStore, currRecord, Record.NO_PREVIOUS_PROPERTY.longValue(), nextPropId, propertyCursor, cursorContext, storeCursors);
            nextPropId = currRecord.getId();
            SchemaRecord schemaRecord = (SchemaRecord)this.schemaStore.newRecord();
            schemaRecord.initialize(true, nextPropId);
            schemaRecord.setId(rule.getId());
            schemaRecord.setCreated();
            this.schemaStore.updateRecord(schemaRecord, schemaCursor, cursorContext, storeCursors);
            this.schemaStore.setHighestPossibleIdInUse(rule.getId());
        }
    }

    private static PropertyRecord newInitialisedPropertyRecord(PropertyStore propertyStore, SchemaRule rule, CursorContext cursorContext) {
        PropertyRecord record = propertyStore.newRecord();
        record.setId(propertyStore.nextId(cursorContext));
        record.setSchemaRuleId(rule.getId());
        record.setCreated();
        return record;
    }

    private static void linkAndWritePropertyRecord(PropertyStore propertyStore, PropertyRecord record, long prevPropId, long nextProp, PageCursor propertyCursor, CursorContext cursorContext, StoreCursors storeCursors) {
        record.setInUse(true);
        record.setPrevProp(prevPropId);
        record.setNextProp(nextProp);
        propertyStore.updateRecord(record, propertyCursor, cursorContext, storeCursors);
        propertyStore.setHighestPossibleIdInUse(record.getId());
    }

    private SchemaRecord loadSchemaRecord(long ruleId, StoreCursors storeCursors) {
        return this.schemaStore.getRecordByCursor(ruleId, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR));
    }

    @VisibleForTesting
    Stream<SchemaRule> streamAllSchemaRules(boolean ignoreMalformed, StoreCursors storeCursors) {
        KernelVersion currentVersion;
        long startId = this.schemaStore.getNumberOfReservedLowIds();
        long endId = this.schemaStore.getHighId();
        Stream<Object> nli = Stream.empty();
        try {
            currentVersion = this.versionSupplier.kernelVersion();
        }
        catch (IllegalStateException ignored) {
            currentVersion = KernelVersion.V4_2;
        }
        if (currentVersion.isLessThan(KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED)) {
            nli = Stream.of(IndexDescriptor.INJECTED_NLI);
        }
        return Stream.concat(LongStream.range(startId, endId).mapToObj(id -> this.schemaStore.getRecordByCursor(id, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.LENIENT_ALWAYS, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR))).filter(AbstractBaseRecord::inUse).flatMap(record -> this.readSchemaRuleThrowingRuntimeException((SchemaRecord)record, ignoreMalformed, storeCursors)), nli);
    }

    private static Stream<IndexDescriptor> indexRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof IndexDescriptor).map(rule -> (IndexDescriptor)rule);
    }

    private static Stream<ConstraintDescriptor> constraintRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof ConstraintDescriptor).map(rule -> (ConstraintDescriptor)rule);
    }

    private Stream<SchemaRule> readSchemaRuleThrowingRuntimeException(SchemaRecord record, boolean ignoreMalformed, StoreCursors storeCursors) {
        try {
            return Stream.of(this.readSchemaRule(record, storeCursors));
        }
        catch (MalformedSchemaRuleException e) {
            if (!ignoreMalformed && this.schemaStore.isInUse(record.getId(), storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR))) {
                throw new RuntimeException(e);
            }
            return Stream.empty();
        }
    }

    private SchemaRule readSchemaRule(SchemaRecord record, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        return SchemaStore.readSchemaRule(record, this.schemaStore.propertyStore(), this.tokenHolders, storeCursors);
    }
}

