/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.LogProvider;

public class StoreFactory {
    private final RecordDatabaseLayout databaseLayout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final LogProvider logProvider;
    private final PageCache pageCache;
    private final RecordFormats recordFormats;
    private final PageCacheTracer cacheTracer;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final ImmutableSet<OpenOption> openOptions;

    public StoreFactory(DatabaseLayout directoryStructure, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider, PageCacheTracer cacheTracer, DatabaseReadOnlyChecker readOnlyChecker) {
        this(directoryStructure, config, idGeneratorFactory, pageCache, fileSystemAbstraction, RecordFormatSelector.selectForStoreOrConfig(config, RecordDatabaseLayout.convert((DatabaseLayout)directoryStructure), fileSystemAbstraction, pageCache, logProvider, cacheTracer), logProvider, cacheTracer, readOnlyChecker, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    public StoreFactory(DatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, RecordFormats recordFormats, LogProvider logProvider, PageCacheTracer cacheTracer, DatabaseReadOnlyChecker readOnlyChecker, ImmutableSet<OpenOption> openOptions) {
        this.databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.recordFormats = recordFormats;
        this.cacheTracer = cacheTracer;
        this.readOnlyChecker = readOnlyChecker;
        this.openOptions = StoreFactory.buildOpenOptions(config, recordFormats, openOptions);
        this.logProvider = logProvider;
        this.pageCache = pageCache;
        RecordFormatPropertyConfigurator.configureRecordFormat(recordFormats, config);
    }

    public NeoStores openAllNeoStores() {
        return this.openNeoStores(false, StoreType.values());
    }

    public NeoStores openAllNeoStores(boolean createStoreIfNotExists) {
        return this.openNeoStores(createStoreIfNotExists, StoreType.values());
    }

    public NeoStores openNeoStores(StoreType ... storeTypes) {
        return this.openNeoStores(false, storeTypes);
    }

    public NeoStores openNeoStores(boolean createStoreIfNotExists, StoreType ... storeTypes) {
        if (createStoreIfNotExists) {
            try {
                this.fileSystemAbstraction.mkdirs(this.databaseLayout.databaseDirectory());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not create database directory: " + String.valueOf(this.databaseLayout.databaseDirectory()), (Throwable)e);
            }
        }
        return new NeoStores(this.fileSystemAbstraction, this.databaseLayout, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, createStoreIfNotExists, this.cacheTracer, this.readOnlyChecker, storeTypes, this.openOptions);
    }

    private static ImmutableSet<OpenOption> buildOpenOptions(Config config, RecordFormats recordFormats, ImmutableSet<OpenOption> openOptions) {
        if (recordFormats.getFormatFamily() != FormatFamily.aligned) {
            return openOptions;
        }
        if (!((Boolean)config.get(GraphDatabaseSettings.pagecache_direct_io)).booleanValue()) {
            return openOptions;
        }
        if (openOptions.contains((Object)PageCacheOpenOptions.DIRECT)) {
            return openOptions;
        }
        return openOptions.newWith((Object)PageCacheOpenOptions.DIRECT);
    }
}

