/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.Optional;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;

public class RecordStoreVersion
implements StoreVersion {
    private final RecordFormats format;

    public RecordStoreVersion(RecordFormats format) {
        this.format = format;
    }

    public String storeVersion() {
        return this.format.storeVersion();
    }

    public boolean hasCapability(Capability capability) {
        return this.format.hasCapability(capability);
    }

    public boolean hasCompatibleCapabilities(StoreVersion otherVersion, CapabilityType type) {
        return this.format.hasCompatibleCapabilities(RecordFormatSelector.selectForVersion(otherVersion.storeVersion()), type);
    }

    public String introductionNeo4jVersion() {
        return this.format.introductionVersion();
    }

    public Optional<String> successorStoreVersion() {
        return RecordFormatSelector.findSuccessor(this.format).map(RecordFormats::storeVersion);
    }

    public String latestStoreVersion() {
        return RecordFormatSelector.findLatestFormatInFamily(this.format).map(RecordFormats::storeVersion).orElse(this.storeVersion());
    }

    public boolean isCompatibleWith(StoreVersion otherVersion) {
        if (!(otherVersion instanceof RecordStoreVersion)) {
            return false;
        }
        return RecordFormatSelector.isStoreAndConfigFormatsCompatible(this.format, ((RecordStoreVersion)otherVersion).format);
    }

    public String toString() {
        return "RecordStoreVersion{format=" + String.valueOf(this.format) + "}";
    }
}

