/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLogger;
import java.util.regex.Pattern;
import org.neo4j.driver.Logger;

public class NettyLogger
extends AbstractInternalLogger {
    private Logger log;
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\{\\}");

    public NettyLogger(String name, Logger log) {
        super(name);
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.log.trace(msg, new Object[0]);
    }

    @Override
    public void trace(String format, Object arg) {
        this.log.trace(this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void trace(String format, Object argA, Object argB) {
        this.log.trace(this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log.trace(this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log.trace("%s%n%s", msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.log.debug(msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object arg) {
        this.log.debug(this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void debug(String format, Object argA, Object argB) {
        this.log.debug(this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log.debug(this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log.debug("%s%n%s", msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.log.info(msg, new Object[0]);
    }

    @Override
    public void info(String format, Object arg) {
        this.log.info(this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void info(String format, Object argA, Object argB) {
        this.log.info(this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log.info(this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log.info("%s%n%s", msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.log.warn(msg, new Object[0]);
    }

    @Override
    public void warn(String format, Object arg) {
        this.log.warn(this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log.warn(this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void warn(String format, Object argA, Object argB) {
        this.log.warn(this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log.warn("%s%n%s", msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String msg) {
        this.log.error(msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.error(format, new Object[]{arg});
    }

    @Override
    public void error(String format, Object argA, Object argB) {
        this.error(format, new Object[]{argA, argB});
    }

    @Override
    public void error(String format, Object ... arguments) {
        format = this.toDriverLoggerFormat(format);
        if (arguments.length == 0) {
            this.log.error(format, null);
            return;
        }
        Object arg = arguments[arguments.length - 1];
        if (arg instanceof Throwable) {
            this.log.error(String.format(format, arguments), (Throwable)arg);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log.error(msg, t);
    }

    private String toDriverLoggerFormat(String format) {
        return PLACE_HOLDER_PATTERN.matcher(format).replaceAll("%s");
    }
}

