/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.ProcessManager;

abstract class AbstractUnixBootloaderOs
extends BootloaderOsAbstraction {
    AbstractUnixBootloaderOs(BootloaderContext ctx) {
        super(ctx);
    }

    @Override
    long start() {
        return this.ctx.processManager().run(this.buildStandardStartArguments(), ProcessManager.behaviour().redirectToUserLog().storePid());
    }

    @Override
    void stop(long pid) throws BootFailureException {
        ProcessHandle process = this.getProcessIfAlive(pid);
        if (process != null) {
            process.destroy();
        }
    }

    @Override
    protected ProcessManager.Behaviour consoleBehaviour() {
        return super.consoleBehaviour().tryStorePid();
    }

    @Override
    void installService() throws BootFailureException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    void uninstallService() throws BootFailureException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    void updateService() throws BootFailureException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    boolean serviceInstalled() {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    Long getPidIfRunning() {
        ProcessHandle handle = this.getProcessIfAlive(this.ctx.processManager().getPidFromFile());
        return handle != null ? Long.valueOf(handle.pid()) : null;
    }

    @Override
    boolean isRunning(long pid) {
        return this.getProcessIfAlive(pid) != null;
    }

    private ProcessHandle getProcessIfAlive(Long pid) {
        if (pid != null) {
            ProcessHandle process = this.ctx.processManager().getProcessHandle(pid);
            return process != null && process.isAlive() ? process : null;
        }
        return null;
    }
}

