/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.factory.Lists;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.util.Preconditions;

abstract class BootloaderContext {
    final PrintStream out;
    final PrintStream err;
    final Class<?> entrypoint;
    private final Function<String, String> envLookup;
    private final Function<String, String> propLookup;
    private final Runtime.Version version;
    private boolean initiated;
    boolean verbose;
    boolean expandCommands;
    List<String> additionalArgs;
    private Path home;
    private Path conf;
    private Configuration config;
    private boolean fullConfig;
    private BootloaderOsAbstraction os;
    private ProcessManager processManager;

    protected BootloaderContext(Class<?> entrypoint) {
        this(System.out, System.err, System::getenv, System::getProperty, entrypoint, Runtime.version());
    }

    protected BootloaderContext(PrintStream out, PrintStream err, Function<String, String> envLookup, Function<String, String> propLookup, Class<?> entrypoint, Runtime.Version version) {
        this.out = out;
        this.err = err;
        this.envLookup = envLookup;
        this.propLookup = propLookup;
        this.entrypoint = entrypoint;
        this.version = version;
    }

    String getEnv(String key) {
        return this.getEnv(key, "", SettingValueParsers.STRING);
    }

    <T> T getEnv(String key, T defaultValue, SettingValueParser<T> parser) {
        return this.getValue(key, defaultValue, parser, this.envLookup);
    }

    String getProp(String key) {
        return this.getProp(key, "", SettingValueParsers.STRING);
    }

    <T> T getProp(String key, T defaultValue, SettingValueParser<T> parser) {
        return this.getValue(key, defaultValue, parser, this.propLookup);
    }

    private <T> T getValue(String key, T defaultValue, SettingValueParser<T> parser, Function<String, String> lookup) {
        this.assertInitiated();
        String value = lookup.apply(key);
        try {
            return (T)(StringUtils.isNotEmpty((CharSequence)value) ? parser.parse(value) : defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new BootFailureException("Failed to parse value for " + key + ". " + e.getMessage(), 1, e);
        }
    }

    void init(boolean expandCommands, boolean verbose, String ... additionalArgs) {
        Preconditions.checkArgument((!this.initiated ? 1 : 0) != 0, (String)"Context already initiated");
        this.initiated = true;
        this.expandCommands = expandCommands;
        this.verbose = verbose;
        this.additionalArgs = Lists.mutable.with((Object[])additionalArgs);
        if (expandCommands) {
            this.additionalArgs.add("--expand-commands");
        }
    }

    Path home() {
        if (this.home == null) {
            this.assertInitiated();
            Path defaultHome = this.getProp("basedir", Path.of("", new String[0]).toAbsolutePath().getParent(), SettingValueParsers.PATH);
            this.home = this.getEnv("NEO4J_HOME", defaultHome, SettingValueParsers.PATH).toAbsolutePath();
        }
        return this.home;
    }

    Path confDir() {
        if (this.conf == null) {
            this.assertInitiated();
            this.conf = this.getEnv("NEO4J_CONF", this.home().resolve(Bootloader.DEFAULT_CONFIG_LOCATION), SettingValueParsers.PATH);
        }
        return this.conf;
    }

    void validateConfig() {
        this.config(true);
    }

    Configuration config() {
        return this.config(false);
    }

    private Configuration config(boolean full) {
        if (this.config == null || !this.fullConfig && full) {
            this.assertInitiated();
            this.config = this.buildConfig(full);
            this.fullConfig = full;
        }
        return this.config;
    }

    private Configuration buildConfig(boolean full) {
        Path confFile = this.confDir().resolve("neo4j.conf");
        try {
            final Predicate<String> filter = full ? BootloaderContext.settingsDeclaredInNeo4j()::contains : this.settingsUsedByBootloader()::contains;
            Config config = Config.newBuilder().commandExpansion(this.expandCommands).setDefaults(this.overriddenDefaultsValues()).set(GraphDatabaseSettings.neo4j_home, (Object)this.home()).fromFile(confFile, false, filter).build();
            return new Configuration((Configuration)config){
                final /* synthetic */ Configuration val$config;
                {
                    this.val$config = configuration;
                }

                public <T> T get(Setting<T> setting) {
                    if (filter.test(setting.name())) {
                        return (T)this.val$config.get(setting);
                    }
                    throw new IllegalArgumentException("Not allowed to read this setting " + setting.name() + ". It has been filtered out");
                }
            };
        }
        catch (RuntimeException e) {
            throw new BootFailureException("Failed to read config " + String.valueOf(confFile) + ": " + e.getMessage(), e);
        }
    }

    private Set<String> settingsUsedByBootloader() {
        return Set.of(GraphDatabaseSettings.neo4j_home.name(), GraphDatabaseSettings.logs_directory.name(), GraphDatabaseSettings.plugin_dir.name(), GraphDatabaseSettings.store_user_log_path.name(), GraphDatabaseSettings.strict_config_validation.name(), GraphDatabaseInternalSettings.config_command_evaluation_timeout.name(), BootloaderSettings.run_directory.name(), BootloaderSettings.additional_jvm.name(), BootloaderSettings.lib_directory.name(), BootloaderSettings.windows_service_name.name(), BootloaderSettings.windows_tools_directory.name(), BootloaderSettings.pid_file.name());
    }

    private static Set<String> settingsDeclaredInNeo4j() {
        return Config.defaults().getDeclaredSettings().keySet();
    }

    protected abstract Map<Setting<?>, Object> overriddenDefaultsValues();

    BootloaderOsAbstraction os() {
        if (this.os == null) {
            this.assertInitiated();
            this.os = BootloaderOsAbstraction.getOsAbstraction(this);
        }
        return this.os;
    }

    ProcessManager processManager() {
        if (this.processManager == null) {
            this.assertInitiated();
            this.processManager = new ProcessManager(this);
        }
        return this.processManager;
    }

    private void assertInitiated() {
        Preconditions.checkArgument((boolean)this.initiated, (String)"Context not initiated");
    }

    Runtime.Version version() {
        return this.version;
    }
}

