/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintStream;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.startup.BootloaderCommand;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.EntryPoint;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="Neo4j", description={"Neo4j database server CLI."}, synopsisSubcommandLabel="<COMMAND>")
class Neo4jCommand
extends BootloaderCommand {
    Neo4jCommand(Neo4jBootloaderContext ctx) {
        super(ctx);
    }

    static CommandLine asCommandLine(Neo4jBootloaderContext ctx) {
        CommandLine cmd = new CommandLine((Object)new Neo4jCommand(ctx)).addSubcommand((Object)new Console()).addSubcommand((Object)new Start()).addSubcommand((Object)new Stop()).addSubcommand((Object)new Restart()).addSubcommand((Object)new Status());
        if (SystemUtils.IS_OS_WINDOWS) {
            cmd.addSubcommand((Object)new InstallService()).addSubcommand((Object)new UninstallService()).addSubcommand((Object)new UpdateService());
        }
        cmd.addSubcommand("version", (Object)new Version(), new String[]{"--version"}).addSubcommand("help", (Object)new CommandLine.HelpCommand(), new String[]{"--help"});
        return Neo4jCommand.addDefaultOptions(cmd, ctx);
    }

    public static void main(String[] args) {
        int exitCode = Neo4jCommand.asCommandLine(new Neo4jBootloaderContext()).execute(args);
        System.exit(exitCode);
    }

    static class Neo4jBootloaderContext
    extends BootloaderContext {
        Neo4jBootloaderContext() {
            super(EntryPoint.serviceloadEntryPoint());
        }

        @VisibleForTesting
        Neo4jBootloaderContext(PrintStream out, PrintStream err, Function<String, String> envLookup, Function<String, String> propLookup, Class<? extends EntryPoint> entrypoint, Runtime.Version version) {
            super(out, err, envLookup, propLookup, entrypoint, version);
        }

        @Override
        protected Map<Setting<?>, Object> overriddenDefaultsValues() {
            return GraphDatabaseSettings.SERVER_DEFAULTS;
        }
    }

    @CommandLine.Command(name="update-service", description={"Update the Windows service."})
    private static class UpdateService
    extends BootloaderCommand.BootCommand {
        private UpdateService() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).updateService();
        }
    }

    @CommandLine.Command(name="uninstall-service", description={"Uninstall the Windows service."})
    private static class UninstallService
    extends BootloaderCommand.BaseCommand {
        private UninstallService() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(false).uninstallService();
        }
    }

    @CommandLine.Command(name="install-service", description={"Install the Windows service."})
    private static class InstallService
    extends BootloaderCommand.BootCommand {
        private InstallService() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).installService();
        }
    }

    @CommandLine.Command(name="version", description={"Print version information and exit."})
    static class Version
    extends BootloaderCommand.BaseCommand {
        Version() {
        }

        @Override
        public Integer call() {
            this.bootloader.ctx.out.println("neo4j " + org.neo4j.kernel.internal.Version.getNeo4jVersion());
            return 0;
        }
    }

    @CommandLine.Command(name="status", description={"Get the status of the server."})
    private static class Status
    extends BootloaderCommand.BootCommand {
        private Status() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).status();
        }
    }

    @CommandLine.Command(name="restart", description={"Restart the server daemon."})
    private static class Restart
    extends BootloaderCommand.BootCommand {
        private Restart() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).restart();
        }
    }

    @CommandLine.Command(name="stop", description={"Stop the server daemon."})
    private static class Stop
    extends BootloaderCommand.BootCommand {
        private Stop() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).stop();
        }
    }

    @CommandLine.Command(name="start", description={"Start server as a daemon."})
    private static class Start
    extends BootloaderCommand.BootCommand {
        private Start() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).start();
        }
    }

    @CommandLine.Command(name="console", description={"Start server in console."})
    private static class Console
    extends BootloaderCommand.BootCommand {
        @CommandLine.Option(names={"--dry-run"}, hidden=true, description={"Print (only) the command line instead of executing it"})
        boolean dryRun;

        private Console() {
        }

        @Override
        public Integer call() {
            return this.getBootloader(this.startOptions.expandCommands).console(this.dryRun);
        }
    }
}

