/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.Preconditions;

class WindowsBootloaderOs
extends BootloaderOsAbstraction {
    static final String PRUNSRV_AMD_64_EXE = "prunsrv-amd64.exe";
    static final String PRUNSRV_I_386_EXE = "prunsrv-i386.exe";
    private static final int WINDOWS_PATH_MAX_LENGTH = 250;

    WindowsBootloaderOs(BootloaderContext ctx) {
        super(ctx);
    }

    @Override
    long start() throws BootFailureException {
        if (!this.serviceInstalled()) {
            throw new BootFailureException("Neo4j service is not installed", 3);
        }
        this.issueServiceCommand("ES", ProcessManager.behaviour().blocking());
        return Long.MAX_VALUE;
    }

    @Override
    void stop(long pid) throws BootFailureException {
        if (this.serviceInstalled()) {
            this.issueServiceCommand("SS", ProcessManager.behaviour());
        }
    }

    @Override
    void installService() throws BootFailureException {
        this.runServiceCommand("IS");
    }

    private void runServiceCommand(String baseCommand) {
        MutableList<String> argList = this.baseServiceCommandArgList(baseCommand);
        Path home = this.ctx.home();
        Path logs = (Path)this.ctx.config().get(GraphDatabaseSettings.logs_directory);
        Path jvmDll = Path.of(this.getJavaCmd(), new String[0]).getParent().resolve(Path.of("server", "jvm.dll"));
        Preconditions.checkState((boolean)Files.exists(jvmDll, new LinkOption[0]), (String)"Couldn't find the jvm DLL file %s", (Object[])new Object[]{jvmDll});
        List<String> jvmOpts = this.getJvmOpts();
        argList.with((Object)WindowsBootloaderOs.arg("--StartMode", "jvm")).with((Object)WindowsBootloaderOs.arg("--StartMethod", "start")).with((Object)WindowsBootloaderOs.arg("--ServiceUser", "LocalSystem")).with((Object)WindowsBootloaderOs.arg("--StartPath", home.toString())).with((Object)WindowsBootloaderOs.multiArg("--StartParams", "--config-dir=" + String.valueOf(this.ctx.confDir()), "--home-dir=" + String.valueOf(home))).with((Object)WindowsBootloaderOs.arg("--StopMode", "jvm")).with((Object)WindowsBootloaderOs.arg("--StopMethod", "stop")).with((Object)WindowsBootloaderOs.arg("--StopPath", home.toString())).with((Object)WindowsBootloaderOs.arg("--Description", "Neo4j Graph Database - " + String.valueOf(home))).with((Object)WindowsBootloaderOs.arg("--DisplayName", "Neo4j Graph Database - " + this.serviceName())).with((Object)WindowsBootloaderOs.arg("--Jvm", jvmDll.toString())).with((Object)WindowsBootloaderOs.arg("--LogPath", logs.toString())).with((Object)WindowsBootloaderOs.arg("--StdOutput", logs.resolve((Path)this.ctx.config().get(GraphDatabaseSettings.store_user_log_path)).toString())).with((Object)WindowsBootloaderOs.arg("--StdError", logs.resolve("service-error.log").toString())).with((Object)WindowsBootloaderOs.arg("--LogPrefix", "neo4j-service")).with((Object)WindowsBootloaderOs.arg("--Classpath", this.getClassPath())).with((Object)WindowsBootloaderOs.multiArg("--JvmOptions", jvmOpts.toArray(new String[0]))).with((Object)WindowsBootloaderOs.arg("--Startup", "auto")).with((Object)WindowsBootloaderOs.arg("--StopClass", this.ctx.entrypoint.getName())).with((Object)WindowsBootloaderOs.arg("--StartClass", this.ctx.entrypoint.getName()));
        for (String additionalArg : this.ctx.additionalArgs) {
            argList = argList.with((Object)WindowsBootloaderOs.arg("++StartParams", additionalArg));
        }
        argList = this.includeMemoryOption(jvmOpts, argList, "-Xms", "--JvmMs", "Start");
        argList = this.includeMemoryOption(jvmOpts, argList, "-Xmx", "--JvmMx", "Max");
        this.runProcess((List<String>)argList, ProcessManager.behaviour().inheritIO().blocking());
    }

    private static String multiArg(String key, String ... values) {
        List argsEscaped = Arrays.stream(values).peek(WindowsBootloaderOs::throwIfContainsSingleQuotes).map(opt -> opt.replace(";", "';'")).map(opt -> opt.replace("#", "'#'")).collect(Collectors.toList());
        return WindowsBootloaderOs.arg(key, StringUtils.join(argsEscaped, (char)';'));
    }

    private static void throwIfContainsSingleQuotes(String s) {
        if (s.contains("'")) {
            int firstIndex = s.indexOf("'");
            String context = s.substring(Math.max(firstIndex - 25, 0), Math.min(s.length(), firstIndex + 25));
            throw new BootFailureException(String.format("We are unable to support values that contain single quote marks ('). Single quotes found in value: %s", context));
        }
    }

    private String serviceName() {
        return (String)this.ctx.config().get(BootloaderSettings.windows_service_name);
    }

    @Override
    void uninstallService() throws BootFailureException {
        this.issueServiceCommand("DS", ProcessManager.behaviour().blocking());
        Stopwatch stopwatch = Stopwatch.start();
        while (this.serviceInstalled() && !stopwatch.hasTimedOut(120L, TimeUnit.SECONDS)) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Override
    void updateService() throws BootFailureException {
        this.runServiceCommand("US");
    }

    @Override
    Long getPidIfRunning() {
        String status = this.getStatus();
        boolean stopped = StringUtils.isEmpty((CharSequence)status) || status.startsWith("Stopped");
        return stopped ? null : Long.valueOf(Long.MAX_VALUE);
    }

    @Override
    boolean isRunning(long pid) {
        return this.getPidIfRunning() != null;
    }

    @Override
    boolean serviceInstalled() {
        return StringUtils.isNotEmpty((CharSequence)this.getStatus());
    }

    private String getStatus() {
        try {
            return Arrays.stream(this.resultFromPowerShellCommand("Get-Service", this.serviceName(), "|", "Format-Table", "-AutoSize")).filter(s -> s.contains(this.serviceName())).findFirst().orElse("");
        }
        catch (BootProcessFailureException e) {
            return "";
        }
    }

    private String[] resultFromPowerShellCommand(String ... command) {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(outBuffer);){
            PrintStream err = new PrintStream(errBuffer);
            try {
                this.ctx.processManager().run(WindowsBootloaderOs.asPowershellScript(List.of(command)), ProcessManager.behaviour().blocking().outputConsumer(out).errorConsumer(err));
                String[] stringArray = outBuffer.toString().split(String.format("%n", new Object[0]));
                err.close();
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    err.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void issueServiceCommand(String serviceCommand, ProcessManager.Behaviour behaviour) {
        this.runProcess((List<String>)this.baseServiceCommandArgList(serviceCommand), behaviour);
    }

    private void runProcess(List<String> command, ProcessManager.Behaviour behaviour) {
        List<String> entireCommand = WindowsBootloaderOs.asExternalCommand(command);
        this.ctx.processManager().run(entireCommand, behaviour);
        if (entireCommand.stream().anyMatch(cmd -> cmd.equals(WindowsBootloaderOs.powershellCmd())) && command.stream().anyMatch(cmd -> cmd.endsWith(PRUNSRV_I_386_EXE) || cmd.endsWith(PRUNSRV_AMD_64_EXE))) {
            Stopwatch stopwatch = Stopwatch.start();
            do {
                try {
                    this.resultFromPowerShellCommand("Get-Process", "prunsrv-amd64.exe,prunsrv-i386.exe");
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (BootProcessFailureException e) {}
                break;
            } while (!stopwatch.hasTimedOut(120L, TimeUnit.SECONDS));
        }
    }

    private MutableList<String> baseServiceCommandArgList(String serviceCommand) {
        return Lists.mutable.with((Object[])new String[]{String.format("& %s", WindowsBootloaderOs.escapeQuote(this.findPrunCommand().toString()))}).with((Object)String.format("//%s//%s", serviceCommand, this.serviceName()));
    }

    private static List<String> asPowershellScript(List<String> command) {
        return WindowsBootloaderOs.asExternalCommand(List.of(String.join((CharSequence)" ", command)));
    }

    private static List<String> asExternalCommand(List<String> command) {
        Stream argsAsOne = command.size() < 2 ? Stream.empty() : Stream.of(command.stream().skip(1L).map(WindowsBootloaderOs::escapeQuote).collect(Collectors.joining(" ")));
        return Stream.concat(Stream.of(WindowsBootloaderOs.powershellCmd(), "-OutputFormat", "Text", "-ExecutionPolicy", "Bypass", "-Command", command.get(0)), argsAsOne).collect(Collectors.toList());
    }

    private static String powershellCmd() {
        return "powershell.exe";
    }

    private Path findPrunCommand() {
        boolean is64bit = StringUtils.isNotEmpty((CharSequence)this.ctx.getEnv("ProgramFiles(x86)"));
        String prunSrvName = is64bit ? PRUNSRV_AMD_64_EXE : PRUNSRV_I_386_EXE;
        Path tools = (Path)this.ctx.config().get(BootloaderSettings.windows_tools_directory);
        Path path = tools.resolve(prunSrvName);
        Preconditions.checkState((boolean)Files.exists(path, new LinkOption[0]), (String)"Couldn't find prunsrv file for interacting with the windows service subsystem %s", (Object[])new Object[]{path});
        int length = path.toString().length();
        if (length >= 250) {
            this.ctx.err.printf("WARNING: Path length over %s characters detected. The service may not work correctly because of limitations in the Windows operating system when dealing with long file paths. Path:%s (length:%s)%n", 250, path, length);
        }
        return path;
    }

    private MutableList<String> includeMemoryOption(List<String> jvmOpts, MutableList<String> argList, String option, String serviceOption, String description) {
        String memory = WindowsBootloaderOs.findOptionValue(jvmOpts, option);
        if (memory != null) {
            argList = argList.with((Object)WindowsBootloaderOs.arg(serviceOption, memory));
            this.ctx.out.println("Use JVM " + description + " Memory of " + memory);
        }
        return argList;
    }

    private static String findOptionValue(List<String> opts, String option) {
        for (String opt : opts) {
            if (!opt.startsWith(option)) continue;
            return opt.substring(option.length());
        }
        return null;
    }

    private static String arg(String key, String value) {
        return value == null ? key : String.format("%s=%s", key, value);
    }

    private static String escapeQuote(String str) {
        return String.format("'%s'", str.replaceAll("'", "''"));
    }
}

