/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.function.Function;
import org.neo4j.cypher.internal.CypherQueryObfuscator$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\t\u0012\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tE\u000f\u0005\u0006!\u0002!\t%\u0015\u0005\u00069\u0002!I!\u0018\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006}\u0002!Ia`\u0004\b\u0003\u000f\t\u0002\u0012AA\u0005\r\u0019\u0001\u0012\u0003#\u0001\u0002\f!1A'\u0003C\u0001\u0003'A\u0011\"!\u0006\n\u0005\u0004%I!a\u0006\t\u0011\u0005u\u0011\u0002)A\u0005\u00033A\u0011\"a\b\n\u0005\u0004%I!!\t\t\u0011\u0005=\u0012\u0002)A\u0005\u0003GAq!!\r\n\t\u0003\t\u0019DA\u000bDsBDWM])vKJLxJ\u00194vg\u000e\fGo\u001c:\u000b\u0005I\u0019\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q)\u0012AB2za\",'O\u0003\u0002\u0017/\u0005)a.Z85U*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0002\u00017\r\u0002\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\t1\fgn\u001a\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0004PE*,7\r\u001e\t\u0003I-j\u0011!\n\u0006\u0003M\u001d\nQ!];fefT!\u0001K\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002++\u000511.\u001a:oK2L!\u0001L\u0013\u0003\u001fE+XM]=PE\u001a,8oY1u_J\fQa\u001d;bi\u0016\u0004\"a\f\u001a\u000e\u0003AR!!M\t\u0002\tU$\u0018\u000e\\\u0005\u0003gA\u00121c\u00142gkN\u001c\u0017\r^5p]6+G/\u00193bi\u0006\fa\u0001P5oSRtDC\u0001\u001c9!\t9\u0004!D\u0001\u0012\u0011\u0015i#\u00011\u0001/\u00035y'MZ;tG\u0006$X\rV3yiR\u00191\b\u0013&\u0011\u0005q*eBA\u001fD!\tq\u0014)D\u0001@\u0015\t\u0001\u0015$\u0001\u0004=e>|GO\u0010\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)Q\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002E\u0003\")\u0011j\u0001a\u0001w\u0005a!/Y<Rk\u0016\u0014\u0018\u0010V3yi\")1j\u0001a\u0001\u0019\u0006y\u0001O]3QCJ\u001cXM](gMN,G\u000f\u0005\u0002N\u001d6\t\u0011)\u0003\u0002P\u0003\n\u0019\u0011J\u001c;\u0002'=\u0014g-^:dCR,\u0007+\u0019:b[\u0016$XM]:\u0015\u0005IS\u0006CA*Y\u001b\u0005!&BA+W\u0003\u001d1\u0018N\u001d;vC2T!aV\u000b\u0002\rY\fG.^3t\u0013\tIFK\u0001\u0005NCB4\u0016\r\\;f\u0011\u0015YF\u00011\u0001S\u0003I\u0011\u0018m^)vKJL\b+\u0019:b[\u0016$XM]:\u0002'1LG/\u001a:bYN#(/\u001b8h\u0019\u0016tw\r\u001e5\u0015\t1s\u0016N\u001b\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\u0013C\u0012T\u0017mY3oi\u000eC\u0017M]1di\u0016\u00148\u000fE\u0002bMnr!A\u00193\u000f\u0005y\u001a\u0017\"\u0001\"\n\u0005\u0015\f\u0015a\u00029bG.\fw-Z\u0005\u0003O\"\u00141aU3r\u0015\t)\u0017\tC\u0003J\u000b\u0001\u00071\bC\u0003l\u000b\u0001\u0007A*A\u0005ge>l\u0017J\u001c3fq\u0006\trN\u00194vg\u000e\fG/\u001a)pg&$\u0018n\u001c8\u0015\u00079\\H\u0010\u0005\u0003pgV,X\"\u00019\u000b\u0005E\u0014\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005Ez\u0012B\u0001;q\u0005!1UO\\2uS>t\u0007C\u0001<z\u001b\u00059(B\u0001=\u0016\u0003\u001d9'/\u00199iI\nL!A_<\u0003\u001b%s\u0007/\u001e;Q_NLG/[8o\u0011\u0015Ie\u00011\u0001<\u0011\u0015ih\u00011\u0001M\u0003=\u0001(/\u001a9beN,'o\u00144gg\u0016$\u0018\u0001\u00034j]\u0012d\u0015N\\3\u0015\u000b1\u000b\t!a\u0001\t\u000b%;\u0001\u0019A\u001e\t\r\u0005\u0015q\u00011\u0001M\u0003\u0019ygMZ:fi\u0006)2)\u001f9iKJ\fV/\u001a:z\u001f\n4Wo]2bi>\u0014\bCA\u001c\n'\rI\u0011Q\u0002\t\u0004\u001b\u0006=\u0011bAA\t\u0003\n1\u0011I\\=SK\u001a$\"!!\u0003\u0002%=\u0013e)V*D\u0003R+Ei\u0018'J)\u0016\u0013\u0016\tT\u000b\u0003\u00033\u00012\u0001HA\u000e\u0013\t1U$A\nP\u0005\u001a+6kQ!U\u000b\u0012{F*\u0013+F%\u0006c\u0005%\u0001\u0006P\u0005\u001a+6kQ!U\u000b\u0012+\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bW\u0003!\u0019Ho\u001c:bE2,\u0017\u0002BA\u0017\u0003O\u0011\u0011\u0002V3yiZ\u000bG.^3\u0002\u0017=\u0013e)V*D\u0003R+E\tI\u0001\u0006CB\u0004H.\u001f\u000b\u0004G\u0005U\u0002BBA\u001c\u001f\u0001\u0007a&A\npE\u001a,8oY1uS>tW*\u001a;bI\u0006$\u0018\r")
public class CypherQueryObfuscator
implements QueryObfuscator {
    private final ObfuscationMetadata state;

    public static QueryObfuscator apply(ObfuscationMetadata obfuscationMetadata) {
        return CypherQueryObfuscator$.MODULE$.apply(obfuscationMetadata);
    }

    public String obfuscateText(String x$1) {
        return super.obfuscateText(x$1);
    }

    public String obfuscateText(String rawQueryText, int preParserOffset) {
        String string;
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            string = rawQueryText;
        } else {
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            IntRef i = IntRef.create((int)0);
            Vector adjacentCharacters = new StringOps(Predef$.MODULE$.augmentString(rawQueryText)).sliding(2).toVector();
            this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable & scala.Serializable)literalOffset -> {
                CypherQueryObfuscator.$anonfun$obfuscateText$1(this, preParserOffset, rawQueryText, i, sb, adjacentCharacters, literalOffset);
                return BoxedUnit.UNIT;
            });
            Object object = i.elem < rawQueryText.length() ? sb.append(rawQueryText.substring(i.elem)) : BoxedUnit.UNIT;
            string = sb.toString();
        }
        return string;
    }

    public MapValue obfuscateParameters(MapValue rawQueryParameters) {
        MapValue mapValue;
        if (this.state.sensitiveParameterNames().isEmpty()) {
            mapValue = rawQueryParameters;
        } else {
            ObjectRef params = ObjectRef.create((Object)rawQueryParameters);
            this.state.sensitiveParameterNames().foreach((Function1 & Serializable & scala.Serializable)p -> {
                params.elem = ((MapValue)params.elem).updatedWith(p, (AnyValue)CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED());
                return BoxedUnit.UNIT;
            });
            mapValue = (MapValue)params.elem;
        }
        return mapValue;
    }

    private int literalStringLength(Seq<String> adjacentCharacters, String rawQueryText, int fromIndex) {
        char openingQuote = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), fromIndex);
        if (openingQuote != '\"' && openingQuote != '\'') {
            throw new IllegalStateException(new StringBuilder(34).append("Expected opening quote at offset ").append(fromIndex).append(".").toString());
        }
        int lastCharacterIndex = adjacentCharacters.indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)CypherQueryObfuscator.$anonfun$literalStringLength$1(openingQuote, s)), fromIndex);
        if (lastCharacterIndex == -1) {
            throw new IllegalStateException("Expected to find closing quote.");
        }
        return lastCharacterIndex - fromIndex + 2;
    }

    public Function<InputPosition, InputPosition> obfuscatePosition(String rawQueryText, int preparserOffset) {
        return this.state.sensitiveLiteralOffsets().isEmpty() ? Function.identity() : in -> {
            Vector adjacentCharacters = new StringOps(Predef$.MODULE$.augmentString(rawQueryText)).sliding(2).toVector();
            IntRef obfuscatedOffset = IntRef.create((int)in.getOffset());
            IntRef obfuscatedColumn = IntRef.create((int)in.getColumn());
            int obfuscatedLength = CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL().length();
            int lineOffset = this.findLine(rawQueryText, preparserOffset);
            $this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable & scala.Serializable)literalOffset -> {
                CypherQueryObfuscator.$anonfun$obfuscatePosition$2(this, preparserOffset, in, adjacentCharacters, rawQueryText, obfuscatedOffset, obfuscatedLength, lineOffset, obfuscatedColumn, literalOffset);
                return BoxedUnit.UNIT;
            });
            return new InputPosition(obfuscatedOffset.elem, in.getLine(), obfuscatedColumn.elem);
        };
    }

    private int findLine(String rawQueryText, int offset) {
        return offset == 0 ? 0 : (int)((String)new StringOps(Predef$.MODULE$.augmentString(rawQueryText)).take(offset + 1)).lines().count() - 1;
    }

    public static final /* synthetic */ void $anonfun$obfuscateText$1(CypherQueryObfuscator $this, int preParserOffset$1, String rawQueryText$1, IntRef i$1, scala.collection.mutable.StringBuilder sb$1, Vector adjacentCharacters$1, LiteralOffset literalOffset) {
        int start = literalOffset.start(preParserOffset$1);
        if (start >= rawQueryText$1.length() || start < i$1.elem) {
            throw new IllegalStateException(new StringBuilder(31).append("Literal offset out of bounds: ").append(literalOffset).append(".").toString());
        }
        sb$1.append(rawQueryText$1.substring(i$1.elem, start));
        sb$1.append(CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL());
        i$1.elem = start + BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.literalStringLength((Seq<String>)adjacentCharacters$1, rawQueryText$1, start)));
    }

    public static final /* synthetic */ boolean $anonfun$literalStringLength$1(char openingQuote$1, String s) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0) != '\\' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 1) == openingQuote$1;
    }

    public static final /* synthetic */ void $anonfun$obfuscatePosition$2(CypherQueryObfuscator $this, int preparserOffset$1, InputPosition in$1, Vector adjacentCharacters$2, String rawQueryText$2, IntRef obfuscatedOffset$1, int obfuscatedLength$1, int lineOffset$1, IntRef obfuscatedColumn$1, LiteralOffset literalOffset) {
        block1: {
            int start = literalOffset.start(preparserOffset$1);
            if (start >= in$1.getOffset()) break block1;
            int length = BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.literalStringLength((Seq<String>)adjacentCharacters$2, rawQueryText$2, start)));
            obfuscatedOffset$1.elem += obfuscatedLength$1 - length;
            if (literalOffset.line(lineOffset$1) == in$1.getLine()) {
                obfuscatedColumn$1.elem += obfuscatedLength$1 - length;
            }
        }
    }

    public CypherQueryObfuscator(ObfuscationMetadata state) {
        this.state = state;
    }
}

