/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.neo4j.fleetmanagement.bootstrap.PluginTask;
import com.neo4j.fleetmanagement.communication.AbstractReportingService;
import com.neo4j.fleetmanagement.communication.model.ConfigurationResponse;
import com.neo4j.fleetmanagement.communication.model.PingMessage;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.io.fs.FileSystemAbstraction;

public class PingService
extends AbstractReportingService {
    private final TopologyMapper topologyMapper;
    private final Configuration configuration;

    public PingService(Config config, FileSystemAbstraction fs, ITransactor transactor, Upstream upstream, ServerIdentity serverIdentity) {
        super(transactor, upstream);
        this.topologyMapper = new TopologyMapper(config, fs, transactor, serverIdentity);
        this.configuration = Configuration.getInstance();
    }

    @Override
    public void report() {
        String serverId;
        String serverVersion;
        if (!this.state.isConnected()) {
            return;
        }
        try {
            serverVersion = this.topologyMapper.getServerVersion();
            serverId = this.topologyMapper.getServerId();
        }
        catch (Exception e) {
            this.userLog.error("Fleet management plugin failed to connect - exception in mapTopology ", (Throwable)e);
            return;
        }
        String projectId = this.upstream.getApiKey().projectId();
        PingMessage msg = new PingMessage(serverId, serverVersion, projectId);
        msg.projectId = this.upstream.getApiKey().projectId();
        AbstractReportingService.Response response = this.transmitReportWithResponse(msg, Upstream.Endpoint.PING);
        if (response == null) {
            this.userLog.error("Fleet management plugin failed to receive configuration");
            return;
        }
        if (response.responseCode == 200 && response.responseBody != null) {
            ConfigurationResponse configurationResponse = null;
            try {
                configurationResponse = (ConfigurationResponse)this.objectMapper.readValue(response.responseBody, ConfigurationResponse.class);
            }
            catch (JsonProcessingException e) {
                this.userLog.warn("Fleet management plugin failed to receive configuration - Failed to deserialize configuration message: " + e.getMessage());
            }
            catch (IOException e) {
                String errorMsg = "Fleet management plugin failed to receive configuration - IOException: " + e.getMessage();
                this.userLog.error(errorMsg);
                this.state.setDisconnected(errorMsg);
                throw new RuntimeException(e);
            }
            if (configurationResponse != null) {
                Configuration.updateConfigurationIfPresent(this.configuration, configurationResponse);
            }
        } else {
            this.userLog.error("Fleet management plugin failed to receive configuration - response code: " + response.responseCode);
        }
    }

    public static class PingTask
    extends PluginTask {
        private final PingService pingService;

        public PingTask(State state, ClusterSync clusterSync, PingService pingService) {
            super(state, clusterSync);
            this.pingService = pingService;
        }

        @Override
        public void execute() {
            if (this.state.isConnected()) {
                this.pingService.report();
            }
        }
    }
}

