/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.configuration;

import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.transactions.ITransactor;

public class ClusterSync {
    private final ITransactor transactor;
    private final Upstream upstream;

    public ClusterSync(ITransactor transactor, Upstream upstream) {
        this.transactor = transactor;
        this.upstream = upstream;
    }

    public void run() {
        State.getInstance().setActive(this.transactor.getTokenStatus());
        State.getInstance().setRotatingToken(this.transactor.getTokenRotationStatus());
        this.syncToken();
    }

    private void syncToken() {
        String token = this.transactor.getToken();
        if (token == null) {
            return;
        }
        try {
            this.upstream.setToken(token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

