/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions;

import com.neo4j.fleetmanagement.common.CachedMethod;
import com.neo4j.fleetmanagement.common.TransactionUtil;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.topology.model.GraphCount;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.model.ResultMap;
import com.neo4j.fleetmanagement.transactions.model.SimpleSemver;
import com.neo4j.fleetmanagement.transactions.model.VersionAndEdition;
import com.neo4j.fleetmanagement.utils.Logger;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.logging.Log;

public abstract class AbstractTransactor {
    public static final String TOKEN_ROTATION_STATE_INDICATOR = "ROTATING";
    protected DatabaseManagementService databaseManagementService;
    protected Log log;
    private VersionAndEdition versionAndEdition;
    private SimpleSemver version;
    private final CachedMethod<Server.License> bloomLicenseCache = new CachedMethod();
    private final CachedMethod<Server.License> gdsLicenseCache = new CachedMethod();

    public void init(DatabaseManagementService databaseManagementService) {
        this.databaseManagementService = databaseManagementService;
        this.log = Logger.getNeo4jLogger();
    }

    public boolean getTokenStatus() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            Boolean status = maybeNode.map(node -> node.hasProperty("token")).orElse(false);
            tx.commit();
            return status;
        });
    }

    public boolean getTokenRotationStatus() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            Boolean status = maybeNode.map(node -> node.hasProperty("token") && node.getProperty("token").equals(TOKEN_ROTATION_STATE_INDICATOR)).orElse(false);
            tx.commit();
            return status;
        });
    }

    public String getToken() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            String token = maybeNode.map(node -> node.getProperty("token").toString()).orElse(null);
            tx.commit();
            return token;
        });
    }

    public VersionAndEdition getVersionAndEdition() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            VersionAndEdition versionAndEdition = new VersionAndEdition();
            Result r = tx.execute("CALL dbms.components() YIELD name, versions, edition");
            tx.commit();
            while (r.hasNext()) {
                Map resultMap = r.next();
                String name = resultMap.get("name").toString();
                if (!name.equals("Neo4j Kernel")) continue;
                versionAndEdition.edition = resultMap.get("edition").toString();
                try {
                    List versions = (List)resultMap.get("versions");
                    versionAndEdition.version = (String)versions.get(0);
                }
                catch (ClassCastException e) {
                    this.log.error("Type casting failed: " + e.getMessage());
                }
                this.versionAndEdition = versionAndEdition;
                return versionAndEdition;
            }
            this.versionAndEdition = versionAndEdition;
            return versionAndEdition;
        });
    }

    public GraphCount getGraphCount(String databaseName) {
        return TransactionUtil.withTransaction(this.databaseManagementService, databaseName, tx -> {
            Result r = tx.execute("CALL db.stats.retrieve(\"GRAPH COUNTS\")");
            while (r.hasNext()) {
                Map result = r.next();
                if (!result.get("section").equals("GRAPH COUNTS")) continue;
                GraphCount graphCount = new GraphCount();
                Object data = result.get("data");
                if (data != null && data instanceof Map) {
                    graphCount.relationshipCount = this.getCount(((Map)data).get("relationships"));
                    graphCount.nodeCount = this.getCount(((Map)data).get("nodes"));
                }
                return graphCount;
            }
            return null;
        });
    }

    private Long getCount(Object listOfCounts) {
        if (listOfCounts instanceof List) {
            if (((List)listOfCounts).isEmpty()) {
                return null;
            }
            for (Object count : (List)listOfCounts) {
                if (!(count instanceof Map) || ((Map)count).size() > 1) continue;
                Object countValue = ((Map)count).get("count");
                return countValue != null ? Long.valueOf(Long.parseLong(countValue.toString())) : null;
            }
        }
        return null;
    }

    protected SimpleSemver mustGetVersion() {
        if (this.versionAndEdition == null) {
            this.getVersionAndEdition();
        }
        if (this.versionAndEdition == null) {
            throw new RuntimeException("unable to execute version specific procedure because the version could not be determined");
        }
        if (this.version == null) {
            this.version = new SimpleSemver(this.versionAndEdition.version);
        }
        return this.version;
    }

    protected void setToken(String token) {
        TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            Node node = maybeNode.orElseGet(() -> tx.createNode(new Label[]{Label.label((String)"FleetManagementConfiguration")}));
            node.setProperty("token", (Object)token);
            tx.commit();
        });
    }

    protected void rotateToken() {
        TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            maybeNode.ifPresent(node -> node.setProperty("token", (Object)TOKEN_ROTATION_STATE_INDICATOR));
            tx.commit();
        });
    }

    protected void deleteToken() {
        TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            maybeNode.ifPresent(Node::delete);
            tx.commit();
            State.getInstance().setActive(false);
        });
    }

    public Server.License getBloomLicense() {
        return this.bloomLicenseCache.GetCachedOrRun(() -> {
            Boolean bloomInstalled = TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("SHOW PROCEDURES YIELD name WHERE name = 'bloom.checkLicenseCompliance'");
                tx.commit();
                return r.hasNext();
            });
            if (!bloomInstalled.booleanValue()) {
                return null;
            }
            Server.License license = new Server.License();
            license.state = Server.License.LicenseState.UNKNOWN;
            license.type = Server.License.LicenseType.UNSUPPORTED;
            return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("call bloom.checkLicenseCompliance() yield message, status, daysLeft");
                tx.commit();
                if (r.hasNext()) {
                    ResultMap result = new ResultMap(r.next());
                    String status = result.getString("status");
                    license.daysLeftOnTrial = result.getInteger("daysLeft", null);
                    switch (status.toLowerCase()) {
                        case "valid": {
                            license.state = Server.License.LicenseState.VALID;
                            license.type = Server.License.LicenseType.COMMERCIAL;
                            break;
                        }
                        case "missing": {
                            license.state = Server.License.LicenseState.NOT_ACCEPTED;
                            license.type = Server.License.LicenseType.COMMERCIAL;
                            break;
                        }
                        case "expired": {
                            license.state = Server.License.LicenseState.EXPIRED;
                            license.type = Server.License.LicenseType.COMMERCIAL;
                            break;
                        }
                        case "not_accepted": {
                            license.state = Server.License.LicenseState.NOT_ACCEPTED;
                            license.type = Server.License.LicenseType.COMMERCIAL;
                            break;
                        }
                    }
                }
                return license;
            });
        });
    }

    public Server.License getGdsLicense() {
        return this.gdsLicenseCache.GetCachedOrRun(() -> {
            Boolean gdsInstalled = TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("SHOW PROCEDURES YIELD name WHERE name = 'gds.debug.sysInfo'");
                tx.commit();
                return r.hasNext();
            });
            if (!gdsInstalled.booleanValue()) {
                return null;
            }
            Server.License license = new Server.License();
            license.state = Server.License.LicenseState.UNKNOWN;
            license.type = Server.License.LicenseType.UNSUPPORTED;
            return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("CALL gds.debug.sysInfo() YIELD key, value");
                tx.commit();
                String edition = "Unlicensed";
                String errorMsg = "";
                ZonedDateTime expirationTime = null;
                while (r.hasNext()) {
                    String key;
                    ResultMap result = new ResultMap(r.next());
                    switch (key = result.getString("key")) {
                        case "gdsLicenseError": {
                            errorMsg = result.getString("value");
                            break;
                        }
                        case "gdsEdition": {
                            edition = result.getString("value");
                            break;
                        }
                        case "gdsLicenseExpirationTime": {
                            try {
                                expirationTime = result.getZonedDateTime("value");
                                break;
                            }
                            catch (Exception e) {
                                this.log.error("Unable to parse gdsLicenseExpirationTime: " + e.getMessage());
                            }
                        }
                    }
                }
                if (!errorMsg.isEmpty()) {
                    this.log.warn("GDS license error: " + errorMsg);
                }
                if (edition.equalsIgnoreCase("licensed")) {
                    license.type = Server.License.LicenseType.COMMERCIAL;
                    license.state = Server.License.LicenseState.VALID;
                } else if (edition.equalsIgnoreCase("unlicensed")) {
                    license.type = Server.License.LicenseType.FREE;
                    license.state = Server.License.LicenseState.VALID;
                } else if (edition.equalsIgnoreCase("invalid")) {
                    license.type = Server.License.LicenseType.COMMERCIAL;
                    license.state = Server.License.LicenseState.INVALID;
                }
                if (expirationTime != null) {
                    ZonedDateTime now = ZonedDateTime.now();
                    long daysLeft = ChronoUnit.DAYS.between(now, expirationTime);
                    license.daysLeftOnTrial = (int)daysLeft;
                    if (daysLeft <= 0L) {
                        license.state = Server.License.LicenseState.EXPIRED;
                    }
                }
                return license;
            });
        });
    }
}

