/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.editions;

import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.transactions.model.ResultMap;
import java.util.List;

public class Shared {
    public static Database getDatabaseWithSharedProps(ResultMap r) {
        Database db = new Database();
        db.name = r.getString("name");
        db.aliases = r.getStringList("aliases");
        db.access = r.getString("access");
        db.databaseId = r.getString("databaseID", null);
        db.requestedStatus = r.getString("requestedStatus");
        db.currentStatus = r.getString("currentStatus");
        db._default = r.getBoolean("default");
        db.home = r.getBoolean("home");
        db.lastCommittedTxn = r.getInteger("lastCommittedTxn", null);
        db.replicationLag = r.getInteger("replicationLag", null);
        return db;
    }

    public static void addV5SpecificProps(Database db, ResultMap r) {
        db.statusMessage = r.getString("statusMessage");
        db.currentPrimariesCount = r.getInteger("currentPrimariesCount", null);
        db.currentSecondariesCount = r.getInteger("currentSecondariesCount", null);
        db.requestedPrimariesCount = r.getInteger("requestedPrimariesCount", null);
        db.requestedSecondariesCount = r.getInteger("requestedSecondariesCount", null);
        db.creationTime = r.getZonedDateTime("creationTime").toEpochSecond();
        db.lastStartTime = r.getZonedDateTime("lastStartTime").toEpochSecond();
        db.store = r.getString("store", null);
        db.writer = r.getBoolean("writer");
        db.type = r.getString("type");
        db.role = db.isComposite() ? null : r.getString("role", "unknown");
        db.graphShards = Shared.getStringListIfPresent(r, "graphShards");
        db.propertyShards = Shared.getStringListIfPresent(r, "propertyShards");
    }

    private static List<String> getStringListIfPresent(ResultMap r, String key) {
        if (r.get(key) != null) {
            return r.getStringList(key);
        }
        return null;
    }

    public static void addV4SpecificProps(Database db, ResultMap r) {
        String role;
        db.role = role = r.getString("role", "unknown");
        db.writer = role.equalsIgnoreCase("leader") || role.equalsIgnoreCase("standalone");
        db.statusMessage = r.getString("error", "");
    }
}

