/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.editions;

import com.neo4j.fleetmanagement.common.TransactionUtil;
import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.AbstractTransactor;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.editions.Shared;
import com.neo4j.fleetmanagement.transactions.model.ResultMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Result;

public class v4_EnterpriseTransactor
extends AbstractTransactor
implements ITransactor {
    @Override
    public Map<String, Server> getServers() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            HashMap<String, Server> instanceMap = new HashMap<String, Server>();
            Result r = tx.execute("CALL dbms.cluster.overview YIELD id, addresses, databases");
            tx.commit();
            while (r.hasNext()) {
                ResultMap result = new ResultMap(r.next());
                Server server = new Server();
                server.serverId = result.getString("id");
                List<String> addresses = result.getStringList("addresses");
                server.address = "unknown";
                for (String address : addresses) {
                    try {
                        URI u = new URI(address);
                        if (!u.getScheme().equals("bolt")) continue;
                        server.address = String.format("%s:%d", u.getHost(), u.getPort());
                        break;
                    }
                    catch (Exception e) {
                        this.log.error("Failed to parse URL: " + e.getMessage());
                    }
                }
                instanceMap.put(server.serverId, server);
            }
            return instanceMap;
        });
    }

    @Override
    public Map<String, List<Database>> getDatabases() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            HashMap<String, List> databasesByInstance = new HashMap<String, List>();
            Result r = tx.execute("SHOW DATABASES YIELD name, role, serverID, aliases, access, databaseID, requestedStatus, currentStatus, error, default, home, lastCommittedTxn, replicationLag");
            tx.commit();
            while (r.hasNext()) {
                ResultMap instanceDatabases = new ResultMap(r.next());
                String serverId = instanceDatabases.get("serverID").toString();
                List dbArray = databasesByInstance.computeIfAbsent(serverId, k -> new ArrayList());
                Database oneDb = Shared.getDatabaseWithSharedProps(instanceDatabases);
                Shared.addV4SpecificProps(oneDb, instanceDatabases);
                dbArray.add(oneDb);
            }
            return databasesByInstance;
        });
    }

    @Override
    public Server.License getLicense() {
        Server.License license = new Server.License();
        license.type = Server.License.LicenseType.UNSUPPORTED;
        license.state = Server.License.LicenseState.UNKNOWN;
        return license;
    }

    @Override
    public void setToken(String token) {
        super.setToken(token);
    }

    @Override
    public void rotateToken() {
        super.rotateToken();
    }

    @Override
    public void deleteToken() {
        super.deleteToken();
    }
}

