/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.model;

public class SimpleSemver {
    private final int major;
    private final int minor;
    private final int patch;

    public SimpleSemver(String version) {
        String[] parts = version.split("[-.]");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        try {
            this.major = Integer.parseInt(parts[0]);
            this.minor = Integer.parseInt(parts[1]);
            this.patch = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in version: " + version);
        }
    }

    public int compareTo(SimpleSemver other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        return this.patch - other.patch;
    }
}

