/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.server.helpers.PropertyTypeDispatcher;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class PropertiesRepresentation
extends MappingRepresentation {
    private final Entity entity;

    PropertiesRepresentation(Entity entity) {
        super(RepresentationType.PROPERTIES);
        this.entity = entity;
    }

    public boolean isEmpty() {
        return !this.entity.getPropertyKeys().iterator().hasNext();
    }

    protected void serialize(MappingSerializer serializer) {
        this.serialize(serializer.writer);
    }

    public void serialize(MappingWriter writer) {
        PropertyTypeDispatcher.consumeProperties((PropertyTypeDispatcher)new Consumer(writer), (Entity)this.entity);
    }

    public static Representation value(Object property) {
        return ValueRepresentation.property((Object)property);
    }

    private static class Consumer
    extends PropertyTypeDispatcher<String, Void> {
        private final MappingWriter writer;

        Consumer(MappingWriter serializer) {
            this.writer = serializer;
        }

        protected Void dispatchBooleanProperty(boolean property, String param) {
            this.writer.writeBoolean(param, property);
            return null;
        }

        protected Void dispatchPointProperty(Point property, String param) {
            MappingWriter pointWriter = this.writer.newMapping(RepresentationType.POINT, param);
            Consumer.writePoint(pointWriter, property);
            pointWriter.done();
            return null;
        }

        protected Void dispatchTemporalProperty(Temporal property, String param) {
            this.writer.writeString(param, property.toString());
            return null;
        }

        protected Void dispatchTemporalAmountProperty(TemporalAmount property, String param) {
            this.writer.writeString(param, property.toString());
            return null;
        }

        protected Void dispatchByteProperty(byte property, String param) {
            this.writer.writeInteger(RepresentationType.BYTE, param, (long)property);
            return null;
        }

        protected Void dispatchCharacterProperty(char property, String param) {
            this.writer.writeInteger(RepresentationType.CHAR, param, (long)property);
            return null;
        }

        protected Void dispatchDoubleProperty(double property, String param) {
            this.writer.writeFloatingPointNumber(RepresentationType.DOUBLE, param, property);
            return null;
        }

        protected Void dispatchFloatProperty(float property, String param) {
            this.writer.writeFloatingPointNumber(RepresentationType.FLOAT, param, (double)property);
            return null;
        }

        protected Void dispatchIntegerProperty(int property, String param) {
            this.writer.writeInteger(RepresentationType.INTEGER, param, (long)property);
            return null;
        }

        protected Void dispatchLongProperty(long property, String param) {
            this.writer.writeInteger(RepresentationType.LONG, param, property);
            return null;
        }

        protected Void dispatchShortProperty(short property, String param) {
            this.writer.writeInteger(RepresentationType.SHORT, param, (long)property);
            return null;
        }

        protected Void dispatchStringProperty(String property, String param) {
            this.writer.writeString(param, property);
            return null;
        }

        protected Void dispatchStringArrayProperty(String[] property, String param) {
            ListWriter list = this.writer.newList(RepresentationType.STRING, param);
            for (String s : property) {
                list.writeString(s);
            }
            list.done();
            return null;
        }

        protected Void dispatchPointArrayProperty(Point[] property, String param) {
            ListWriter list = this.writer.newList(RepresentationType.POINT, param);
            for (Point p : property) {
                MappingWriter pointWriter = list.newMapping(RepresentationType.POINT);
                Consumer.writePoint(pointWriter, p);
                pointWriter.done();
            }
            list.done();
            return null;
        }

        protected Void dispatchTemporalArrayProperty(Temporal[] property, String param) {
            ListWriter list = this.writer.newList(RepresentationType.TEMPORAL, param);
            for (Temporal p : property) {
                list.writeString(p.toString());
            }
            list.done();
            return null;
        }

        protected Void dispatchTemporalAmountArrayProperty(TemporalAmount[] property, String param) {
            ListWriter list = this.writer.newList(RepresentationType.TEMPORAL_AMOUNT, param);
            for (TemporalAmount p : property) {
                list.writeString(p.toString());
            }
            list.done();
            return null;
        }

        protected Void dispatchByteArrayProperty(PropertyTypeDispatcher.PropertyArray<Byte> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.BYTE, param);
            for (Byte b : array) {
                list.writeInteger(RepresentationType.BYTE, (long)b.byteValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchShortArrayProperty(PropertyTypeDispatcher.PropertyArray<Short> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.SHORT, param);
            for (Short s : array) {
                list.writeInteger(RepresentationType.SHORT, (long)s.shortValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchCharacterArrayProperty(PropertyTypeDispatcher.PropertyArray<Character> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.CHAR, param);
            for (Character c : array) {
                list.writeInteger(RepresentationType.CHAR, (long)c.charValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchIntegerArrayProperty(PropertyTypeDispatcher.PropertyArray<Integer> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.INTEGER, param);
            for (Integer i : array) {
                list.writeInteger(RepresentationType.INTEGER, (long)i.intValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchLongArrayProperty(PropertyTypeDispatcher.PropertyArray<Long> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.LONG, param);
            for (Long j : array) {
                list.writeInteger(RepresentationType.LONG, j.longValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchFloatArrayProperty(PropertyTypeDispatcher.PropertyArray<Float> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.FLOAT, param);
            for (Float f : array) {
                list.writeFloatingPointNumber(RepresentationType.FLOAT, (double)f.floatValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchDoubleArrayProperty(PropertyTypeDispatcher.PropertyArray<Double> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.DOUBLE, param);
            for (Double d : array) {
                list.writeFloatingPointNumber(RepresentationType.DOUBLE, d.doubleValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchBooleanArrayProperty(PropertyTypeDispatcher.PropertyArray<Boolean> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.BOOLEAN, param);
            for (Boolean z : array) {
                list.writeBoolean(z.booleanValue());
            }
            list.done();
            return null;
        }

        private static void writePoint(MappingWriter pointWriter, Point property) {
            pointWriter.writeString("type", property.getGeometryType());
            ListWriter coordinatesWriter = pointWriter.newList(RepresentationType.DOUBLE, "coordinates");
            for (Double coordinate : property.getCoordinate().getCoordinate()) {
                coordinatesWriter.writeFloatingPointNumber(RepresentationType.DOUBLE, coordinate.doubleValue());
            }
            coordinatesWriter.done();
            CRS crs = property.getCRS();
            MappingWriter crsWriter = pointWriter.newMapping(RepresentationType.MAP, "crs");
            crsWriter.writeInteger(RepresentationType.INTEGER, "srid", (long)crs.getCode());
            crsWriter.writeString("name", crs.getType());
            crsWriter.writeString("type", "link");
            MappingWriter propertiesWriter = crsWriter.newMapping(Representation.MAP, "properties");
            propertiesWriter.writeString("href", crs.getHref() + "ogcwkt/");
            propertiesWriter.writeString("type", "ogcwkt");
            propertiesWriter.done();
            crsWriter.done();
        }
    }
}

