/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.packstream.utf8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.neo4j.bolt.packstream.utf8.UTF8Encoder;
import org.neo4j.bolt.packstream.utf8.VanillaUTF8Encoder;
import org.neo4j.util.FeatureToggles;

public class GCFreeUTF8Encoder
implements UTF8Encoder {
    private static final int BUFFER_SIZE = FeatureToggles.getInteger(GCFreeUTF8Encoder.class, (String)"buffer_size", (int)16384);
    private static final MethodHandle getByteArray = GCFreeUTF8Encoder.byteArrayGetter();
    private static final MethodHandle getCoder = GCFreeUTF8Encoder.coderGetter();
    private static final MethodHandle hasNegatives = GCFreeUTF8Encoder.hasNegatives();
    private static final MethodHandle getChar = GCFreeUTF8Encoder.getChar();
    private static final byte UTF16 = 1;
    private final UTF8Encoder fallbackEncoder = new VanillaUTF8Encoder();
    private final byte[] out = new byte[BUFFER_SIZE];
    private final ByteBuffer outBuf = ByteBuffer.wrap(this.out);

    @Override
    public ByteBuffer encode(String input) {
        try {
            byte coder = getCoder.invoke(input);
            byte[] rawBytes = getByteArray.invoke(input);
            int len = GCFreeUTF8Encoder.encodeUTF8(coder, rawBytes, this.out);
            if (len == -1) {
                return this.fallbackEncoder.encode(input);
            }
            this.outBuf.position(0);
            this.outBuf.limit(len);
            return this.outBuf;
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends on java.lang.StringCoding, which failed to load or apply: " + e.getMessage(), e);
        }
    }

    private static int encodeUTF8(byte coder, byte[] val, byte[] dst) throws Throwable {
        if (coder == 1) {
            return GCFreeUTF8Encoder.encodeUTF8_UTF16(val, dst);
        }
        if (!hasNegatives.invoke(val, 0, val.length)) {
            if (val.length > dst.length) {
                return -1;
            }
            System.arraycopy(val, 0, dst, 0, val.length);
            return val.length;
        }
        int len = val.length << 1;
        if (len > dst.length) {
            return -1;
        }
        int dp = 0;
        for (byte c : val) {
            if (c < 0) {
                dst[dp++] = (byte)(0xC0 | (c & 0xFF) >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            dst[dp++] = c;
        }
        return dp;
    }

    private static int encodeUTF8_UTF16(byte[] val, byte[] dst) throws Throwable {
        char c;
        int sp;
        int dp = 0;
        int sl = val.length >> 1;
        int len = sl * 3;
        if (len > dst.length) {
            return -1;
        }
        for (sp = 0; sp < sl && (c = getChar.invoke(val, sp)) < '\u0080'; ++sp) {
            dst[dp++] = (byte)c;
        }
        while (sp < sl) {
            if ((c = getChar.invoke(val, sp++)) < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp++] = (byte)(0xC0 | c >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char c2;
                int uc = -1;
                if (Character.isHighSurrogate(c) && sp < sl && Character.isLowSurrogate(c2 = getChar.invoke(val, sp))) {
                    uc = Character.toCodePoint(c, c2);
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                ++sp;
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }

    private static MethodHandle hasNegatives() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Method hasNegatives = Class.forName("java.lang.StringCoding").getMethod("hasNegatives", byte[].class, Integer.TYPE, Integer.TYPE);
            hasNegatives.setAccessible(true);
            return lookup.unreflect(hasNegatives);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends on java.lang.StringCoding, which failed to load: " + e.getMessage(), e);
        }
    }

    private static MethodHandle getChar() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Method getChar = Class.forName("java.lang.StringUTF16").getDeclaredMethod("getChar", byte[].class, Integer.TYPE);
            getChar.setAccessible(true);
            return lookup.unreflect(getChar);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends on java.lang.StringUTF16, which failed to load: " + e.getMessage(), e);
        }
    }

    private static MethodHandle coderGetter() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Field coder = String.class.getDeclaredField("coder");
            if (coder.getType() != Byte.TYPE) {
                throw new AssertionError((Object)("This encoder depends being able to access raw byte in java.lang.String, but the class is backed by a " + coder.getType().getCanonicalName()));
            }
            coder.setAccessible(true);
            return lookup.unreflectGetter(coder);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends being able to access raw byte in java.lang.String, which failed: " + e.getMessage(), e);
        }
    }

    private static MethodHandle byteArrayGetter() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Field value = String.class.getDeclaredField("value");
            if (value.getType() != byte[].class) {
                throw new AssertionError((Object)("This encoder depends being able to access raw byte[] in java.lang.String, but the class is backed by a " + value.getType().getCanonicalName()));
            }
            value.setAccessible(true);
            return lookup.unreflectGetter(value);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends being able to access raw byte[] in java.lang.String, which failed: " + e.getMessage(), e);
        }
    }
}

