/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44.messaging.decoder;

import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class MessageMetadataParser {
    private static final String IMPERSONATION_USER_KEY = "imp_user";

    private MessageMetadataParser() {
    }

    public static String parseImpersonatedUser(MapValue value) throws BoltIOException {
        AnyValue anyValue = value.get(IMPERSONATION_USER_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof StringValue) {
            return ((StringValue)anyValue).stringValue();
        }
        throw new BoltIOException((Status)Status.Request.Invalid, "Expecting impersonated user value to be a String value, but got: " + String.valueOf(anyValue));
    }
}

