/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.aligned.PageAlignedV4_1;
import org.neo4j.kernel.impl.store.format.aligned.PageAlignedV4_3;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.store.format.standard.StandardV4_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV4_3;
import org.neo4j.logging.LogProvider;
import org.neo4j.service.Services;

public class RecordFormatSelector {
    private static final String STORE_SELECTION_TAG = "storeSelection";
    private static final RecordFormats DEFAULT_FORMAT = PageAlignedV4_3.RECORD_FORMATS;
    private static final List<RecordFormats> KNOWN_FORMATS = Arrays.asList(StandardV3_4.RECORD_FORMATS, StandardV4_0.RECORD_FORMATS, StandardV4_3.RECORD_FORMATS, PageAlignedV4_1.RECORD_FORMATS, PageAlignedV4_3.RECORD_FORMATS);

    private RecordFormatSelector() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static RecordFormats defaultFormat() {
        return DEFAULT_FORMAT;
    }

    public static RecordFormats selectForVersion(String storeVersion) {
        for (RecordFormats format : RecordFormatSelector.allFormats()) {
            if (!format.storeVersion().equals(storeVersion)) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown store version '" + storeVersion + "'");
    }

    public static RecordFormats selectForConfig(Config config, LogProvider logProvider) {
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        if (StringUtils.isEmpty((CharSequence)recordFormat)) {
            RecordFormatSelector.info(logProvider, "Record format not configured, selected default: " + String.valueOf(RecordFormatSelector.defaultFormat()));
            return RecordFormatSelector.defaultFormat();
        }
        RecordFormats format = RecordFormatSelector.selectSpecificFormat(recordFormat);
        RecordFormatSelector.info(logProvider, "Selected record format based on config: " + String.valueOf(format));
        return format;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RecordFormats selectForStore(RecordDatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        Path neoStoreFile = databaseLayout.metadataStore();
        if (!fs.fileExists(neoStoreFile)) return null;
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(STORE_SELECTION_TAG));){
            RecordFormats format;
            long value = MetaDataStore.getRecord(pageCache, neoStoreFile, MetaDataStore.Position.STORE_VERSION, databaseLayout.getDatabaseName(), cursorContext);
            if (value == -1L) return null;
            String storeVersion = MetaDataStore.versionLongToString(value);
            Iterator<RecordFormats> iterator = RecordFormatSelector.allFormats().iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!(format = iterator.next()).storeVersion().equals(storeVersion));
            RecordFormatSelector.info(logProvider, "Selected " + String.valueOf(format) + " record format from store " + String.valueOf(databaseLayout.databaseDirectory()));
            RecordFormats recordFormats = format;
            return recordFormats;
        }
        catch (IOException e) {
            RecordFormatSelector.info(logProvider, String.format("Unable to read format for store %s. %s ", databaseLayout.databaseDirectory(), e.getMessage()));
        }
        return null;
    }

    public static RecordFormats selectForStoreOrConfig(Config config, RecordDatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        boolean storeWithFormatExists;
        RecordFormats configuredFormat = RecordFormatSelector.getConfiguredRecordFormat(config, (DatabaseLayout)databaseLayout);
        boolean formatConfigured = configuredFormat != null;
        RecordFormats currentFormat = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider, pageCacheTracer);
        boolean bl = storeWithFormatExists = currentFormat != null;
        if (formatConfigured && storeWithFormatExists) {
            if (RecordFormatSelector.formatSameFamilyAndGeneration(currentFormat, configuredFormat)) {
                RecordFormatSelector.info(logProvider, String.format("Configured format matches format in the store %s. Selected: %s", databaseLayout.databaseDirectory(), currentFormat));
                return currentFormat;
            }
            throw new IllegalArgumentException(String.format("Configured format '%s' is different from the actual format in the store %s, which was '%s'", configuredFormat, databaseLayout.databaseDirectory(), currentFormat));
        }
        if (!formatConfigured && storeWithFormatExists) {
            RecordFormatSelector.info(logProvider, String.format("Format not configured for store %s. Selected format from the store files: %s", databaseLayout.databaseDirectory(), currentFormat));
            return currentFormat;
        }
        if (formatConfigured) {
            RecordFormatSelector.info(logProvider, String.format("Selected configured format for store %s: %s", databaseLayout.databaseDirectory(), configuredFormat));
            return configuredFormat;
        }
        return DEFAULT_FORMAT;
    }

    private static RecordFormats getConfiguredRecordFormat(Config config, DatabaseLayout databaseLayout) {
        if ("system".equals(databaseLayout.getDatabaseName())) {
            return null;
        }
        return RecordFormatSelector.loadRecordFormat(RecordFormatSelector.configuredRecordFormat(config));
    }

    private static boolean formatSameFamilyAndGeneration(RecordFormats left, RecordFormats right) {
        return left.getFormatFamily().equals((Object)right.getFormatFamily()) && left.generation() == right.generation();
    }

    public static boolean isStoreAndConfigFormatsCompatible(RecordFormats format, RecordFormats otherFormat) {
        return format == null || otherFormat == null || RecordFormatSelector.formatSameFamilyAndGeneration(format, otherFormat);
    }

    public static RecordFormats selectNewestFormat(Config config, RecordDatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        boolean formatConfigured = StringUtils.isNotEmpty((CharSequence)RecordFormatSelector.configuredRecordFormat(config));
        if (formatConfigured) {
            return RecordFormatSelector.selectForConfig(config, logProvider);
        }
        RecordFormats result = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider, pageCacheTracer);
        if (result == null) {
            RecordFormatSelector.info(logProvider, String.format("Selected format '%s' for the new store %s", DEFAULT_FORMAT, databaseLayout.databaseDirectory()));
            return DEFAULT_FORMAT;
        }
        Optional<RecordFormats> newestFormatInFamily = RecordFormatSelector.findLatestFormatInFamily(result);
        RecordFormats newestFormat = newestFormatInFamily.orElse(result);
        RecordFormatSelector.info(logProvider, String.format("Selected format '%s' for existing store %s with format '%s'", newestFormat, databaseLayout.databaseDirectory(), result));
        return newestFormat;
    }

    public static Optional<RecordFormats> findLatestFormatInFamily(RecordFormats result) {
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(format -> format.getFormatFamily() == result.getFormatFamily()).max(Comparator.comparingInt(RecordFormats::generation));
    }

    public static Optional<RecordFormats> findSuccessor(RecordFormats format) {
        return StreamSupport.stream(RecordFormatSelector.allFormats().spliterator(), false).filter(candidate -> candidate.getFormatFamily() == format.getFormatFamily()).filter(candidate -> candidate.generation() > format.generation()).reduce((a, b) -> a.generation() < b.generation() ? a : b);
    }

    public static Iterable<RecordFormats> allFormats() {
        Collection loadableFormatFactories = Services.loadAll(RecordFormats.Factory.class);
        Iterable loadableFormats = Iterables.map(RecordFormats.Factory::newInstance, (Iterable)loadableFormatFactories);
        return Iterables.concat((Iterable[])new Iterable[]{KNOWN_FORMATS, loadableFormats});
    }

    private static RecordFormats selectSpecificFormat(String recordFormat) {
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(recordFormat);
        if (formats == null) {
            throw new IllegalArgumentException("No record format found with the name '" + recordFormat + "'.");
        }
        return formats;
    }

    private static RecordFormats loadRecordFormat(String recordFormat) {
        if (StringUtils.isEmpty((CharSequence)recordFormat)) {
            return null;
        }
        if (Standard.LATEST_NAME.equals(recordFormat)) {
            return Standard.LATEST_RECORD_FORMATS;
        }
        for (RecordFormats knownFormat : KNOWN_FORMATS) {
            if (!recordFormat.equals(knownFormat.name())) continue;
            return knownFormat;
        }
        return Services.load(RecordFormats.Factory.class, (String)recordFormat).map(RecordFormats.Factory::newInstance).orElse(null);
    }

    private static void info(LogProvider logProvider, String message) {
        logProvider.getLog(RecordFormatSelector.class).info(message);
    }

    private static String configuredRecordFormat(Config config) {
        return (String)config.get(GraphDatabaseSettings.record_format);
    }
}

