/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleDeserializer2_0to3_1;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.string.UTF8;

public class SchemaRuleSerialization35 {
    private static final byte INDEX_RULE = 11;
    private static final byte CONSTRAINT_RULE = 12;
    private static final byte GENERAL_INDEX = 31;
    private static final byte UNIQUE_INDEX = 32;
    private static final byte EXISTS_CONSTRAINT = 61;
    private static final byte UNIQUE_CONSTRAINT = 62;
    private static final byte UNIQUE_EXISTS_CONSTRAINT = 63;
    private static final byte SIMPLE_LABEL = 91;
    private static final byte SIMPLE_REL_TYPE = 92;
    private static final byte GENERIC_MULTI_TOKEN_TYPE = 93;
    private static final long NO_OWNING_CONSTRAINT_YET = -1L;
    private static final int LEGACY_LABEL_OR_REL_TYPE_ID = -1;

    private SchemaRuleSerialization35() {
    }

    public static byte[] serialize(SchemaRule schemaRule, MemoryTracker memoryTracker) {
        if (schemaRule instanceof IndexDescriptor) {
            return SchemaRuleSerialization35.serialize((IndexDescriptor)schemaRule, memoryTracker);
        }
        if (schemaRule instanceof ConstraintDescriptor) {
            return SchemaRuleSerialization35.serialize((ConstraintDescriptor)schemaRule, memoryTracker);
        }
        throw new IllegalStateException("Unknown schema rule type: " + String.valueOf(schemaRule.getClass()));
    }

    public static SchemaRule deserialize(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        int legacyLabelOrRelTypeId = source.getInt();
        byte schemaRuleType = source.get();
        switch (schemaRuleType) {
            case 11: {
                return SchemaRuleSerialization35.readIndexRule(id, source);
            }
            case 12: {
                return SchemaRuleSerialization35.readConstraintRule(id, source);
            }
        }
        if (SchemaRuleDeserializer2_0to3_1.isLegacySchemaRule(schemaRuleType)) {
            return SchemaRuleDeserializer2_0to3_1.deserialize(id, legacyLabelOrRelTypeId, schemaRuleType, source);
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema rule type '%d'.", schemaRuleType));
    }

    public static byte[] serialize(IndexDescriptor indexDescriptor, MemoryTracker memoryTracker) {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(SchemaRuleSerialization35.lengthOf(indexDescriptor), memoryTracker);){
            ByteBuffer target = scopedBuffer.getBuffer();
            target.putInt(-1);
            target.put((byte)11);
            UTF8.putEncodedStringInto((String)indexDescriptor.getIndexProvider().getKey(), (ByteBuffer)target);
            UTF8.putEncodedStringInto((String)indexDescriptor.getIndexProvider().getVersion(), (ByteBuffer)target);
            if (!indexDescriptor.isUnique()) {
                target.put((byte)31);
            } else {
                target.put((byte)32);
                target.putLong(indexDescriptor.getOwningConstraintId().orElse(-1L));
            }
            indexDescriptor.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
            UTF8.putEncodedStringInto((String)indexDescriptor.getName(), (ByteBuffer)target);
            byte[] byArray = target.array();
            return byArray;
        }
    }

    public static byte[] serialize(ConstraintDescriptor constraint, MemoryTracker memoryTracker) {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(SchemaRuleSerialization35.lengthOf(constraint), memoryTracker);){
            ByteBuffer target = scopedBuffer.getBuffer();
            target.putInt(-1);
            target.put((byte)12);
            switch (constraint.type()) {
                case EXISTS: {
                    target.put((byte)61);
                    break;
                }
                case UNIQUE: {
                    target.put((byte)62);
                    target.putLong(constraint.asIndexBackedConstraint().ownedIndexId());
                    break;
                }
                case UNIQUE_EXISTS: {
                    target.put((byte)63);
                    target.putLong(constraint.asIndexBackedConstraint().ownedIndexId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Got unknown index descriptor type '%s'.", constraint.type()));
                }
            }
            constraint.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
            UTF8.putEncodedStringInto((String)constraint.getName(), (ByteBuffer)target);
            byte[] byArray = target.array();
            return byArray;
        }
    }

    static int lengthOf(IndexDescriptor indexDescriptor) {
        int length = 4;
        ++length;
        length += UTF8.computeRequiredByteBufferSize((String)indexDescriptor.getIndexProvider().getKey());
        length += UTF8.computeRequiredByteBufferSize((String)indexDescriptor.getIndexProvider().getVersion());
        ++length;
        if (indexDescriptor.isUnique()) {
            length += 8;
        }
        length += SchemaRuleSerialization35.computeSchemaSize(indexDescriptor.schema());
        return length += UTF8.computeRequiredByteBufferSize((String)indexDescriptor.getName());
    }

    static int lengthOf(ConstraintDescriptor constraint) {
        int length = 4;
        ++length;
        ++length;
        if (constraint.enforcesUniqueness()) {
            length += 8;
        }
        length += SchemaRuleSerialization35.computeSchemaSize(constraint.schema());
        return length += UTF8.computeRequiredByteBufferSize((String)constraint.getName());
    }

    private static IndexDescriptor readIndexRule(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)source);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)source);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        byte indexRuleType = source.get();
        switch (indexRuleType) {
            case 31: {
                SchemaDescriptor schema = SchemaRuleSerialization35.readSchema(source);
                Optional<String> name = SchemaRuleSerialization35.readRuleName(source);
                IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor);
                if (schema.isFulltextSchemaDescriptor()) {
                    prototype = prototype.withIndexType(IndexType.FULLTEXT);
                }
                prototype = name.isPresent() ? prototype.withName(name.get()) : prototype.withName(SchemaRuleDeserializer2_0to3_1.defaultIndexName(id));
                return prototype.materialise(id);
            }
            case 32: {
                long readOwningConstraint = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization35.readSchema(source);
                Optional<String> name = SchemaRuleSerialization35.readRuleName(source);
                IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor);
                prototype = name.isPresent() ? prototype.withName(name.get()) : prototype.withName(SchemaRuleDeserializer2_0to3_1.defaultIndexName(id));
                IndexDescriptor index = prototype.materialise(id);
                if (readOwningConstraint != -1L) {
                    index = index.withOwningConstraintId(readOwningConstraint);
                }
                return index;
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown index rule type '%d'.", indexRuleType));
    }

    private static ConstraintDescriptor readConstraintRule(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        byte constraintRuleType = source.get();
        switch (constraintRuleType) {
            case 61: {
                SchemaDescriptor schema = SchemaRuleSerialization35.readSchema(source);
                String name = SchemaRuleSerialization35.readRuleName(source).orElse(null);
                return ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema).withId(id).withName(name);
            }
            case 62: {
                long ownedUniqueIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization35.readSchema(source);
                UniquenessConstraintDescriptor descriptor = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
                String name = SchemaRuleSerialization35.readRuleName(source).orElse(null);
                return descriptor.withId(id).withOwnedIndexId(ownedUniqueIndex).withName(name);
            }
            case 63: {
                long ownedNodeKeyIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization35.readSchema(source);
                NodeKeyConstraintDescriptor nodeKeyConstraintDescriptor = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schema);
                String name = SchemaRuleSerialization35.readRuleName(source).orElse(null);
                return nodeKeyConstraintDescriptor.withId(id).withOwnedIndexId(ownedNodeKeyIndex).withName(name);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown constraint rule type '%d'.", constraintRuleType));
    }

    private static Optional<String> readRuleName(ByteBuffer source) {
        if (source.remaining() >= 4) {
            String ruleName = UTF8.getDecodedStringFrom((ByteBuffer)source);
            return ruleName.isEmpty() ? Optional.empty() : Optional.of(ruleName);
        }
        return Optional.empty();
    }

    private static SchemaDescriptor readSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        byte schemaDescriptorType = source.get();
        switch (schemaDescriptorType) {
            case 91: {
                int labelId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization35.readTokenIdList(source);
                return SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds);
            }
            case 92: {
                int relTypeId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization35.readTokenIdList(source);
                return SchemaDescriptors.forRelType((int)relTypeId, (int[])propertyIds);
            }
            case 93: {
                return SchemaRuleSerialization35.readMultiTokenSchema(source);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema descriptor type '%d'.", schemaDescriptorType));
    }

    private static SchemaDescriptor readMultiTokenSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        EntityType type;
        byte schemaDescriptorType = source.get();
        switch (schemaDescriptorType) {
            case 91: {
                type = EntityType.NODE;
                break;
            }
            case 92: {
                type = EntityType.RELATIONSHIP;
                break;
            }
            default: {
                throw new MalformedSchemaRuleException(String.format("Got unknown schema descriptor type '%d'.", schemaDescriptorType));
            }
        }
        int[] entityTokenIds = SchemaRuleSerialization35.readTokenIdList(source);
        int[] propertyIds = SchemaRuleSerialization35.readTokenIdList(source);
        return SchemaDescriptors.fulltext((EntityType)type, (int[])entityTokenIds, (int[])propertyIds);
    }

    private static int[] readTokenIdList(ByteBuffer source) {
        int numProperties = source.getShort();
        int[] propertyIds = new int[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            propertyIds[i] = source.getInt();
        }
        return propertyIds;
    }

    private static int computeSchemaSize(SchemaDescriptor schema) {
        if (schema.isLabelSchemaDescriptor()) {
            return 7 + 4 * schema.getPropertyIds().length;
        }
        if (schema.isRelationshipTypeSchemaDescriptor()) {
            return 7 + 4 * schema.getPropertyIds().length;
        }
        return 4 + 4 * schema.getEntityTokenIds().length + 2 + 4 * schema.getPropertyIds().length;
    }

    private static class SchemaDescriptorSerializer
    implements SchemaProcessor {
        private final ByteBuffer target;

        SchemaDescriptorSerializer(ByteBuffer target) {
            this.target = target;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            this.target.put((byte)91);
            this.target.putInt(schema.getLabelId());
            this.putIds(schema.getPropertyIds());
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.target.put((byte)92);
            this.target.putInt(schema.getRelTypeId());
            this.putIds(schema.getPropertyIds());
        }

        public void processSpecific(SchemaDescriptor schema) {
            this.target.put((byte)93);
            if (schema.entityType() == EntityType.NODE) {
                this.target.put((byte)91);
            } else {
                this.target.put((byte)92);
            }
            this.putIds(schema.getEntityTokenIds());
            this.putIds(schema.getPropertyIds());
        }

        private void putIds(int[] ids) {
            this.target.putShort((short)ids.length);
            for (int entityTokenId : ids) {
                this.target.putInt(entityTokenId);
            }
        }
    }
}

