/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import java.util.Iterator;
import java.util.List;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.SchemaStorage;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore35;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore35StoreCursors;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class SchemaStorage35
implements SchemaStorage {
    private static final ThrowingConsumer<Exception, RuntimeException> PROPAGATE_EXCEPTION_HANDLER = e -> {
        Exceptions.throwIfUnchecked((Throwable)e);
        throw new RuntimeException((Throwable)e);
    };
    private static final ThrowingConsumer<Exception, RuntimeException> IGNORE_EXCEPTION_HANDLER = ThrowingConsumer.noop();
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage35(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    @Override
    public Iterable<SchemaRule> getAll(StoreCursors storeCursors) {
        return () -> this.loadAllSchemaRules((SchemaStore35StoreCursors)storeCursors, PROPAGATE_EXCEPTION_HANDLER);
    }

    public Iterable<SchemaRule> getAllIgnoreMalformed(StoreCursors storeCursors) {
        return () -> this.loadAllSchemaRules((SchemaStore35StoreCursors)storeCursors, IGNORE_EXCEPTION_HANDLER);
    }

    public Iterator<IndexDescriptor> indexesGetAll(SchemaStore35StoreCursors storeCursors) {
        return this.loadAllSchemaRules(IndexDescriptor.class, storeCursors, PROPAGATE_EXCEPTION_HANDLER);
    }

    public IndexDescriptor indexGetForName(String indexName, SchemaStore35StoreCursors storeCursors) {
        Iterator<IndexDescriptor> itr = this.indexesGetAll(storeCursors);
        while (itr.hasNext()) {
            IndexDescriptor sid = itr.next();
            if (!sid.getName().equals(indexName)) continue;
            return sid;
        }
        return null;
    }

    private Iterator<SchemaRule> loadAllSchemaRules(SchemaStore35StoreCursors storeCursors, ThrowingConsumer<Exception, RuntimeException> malformedExceptionHandler) {
        return this.loadAllSchemaRules(SchemaRule.class, storeCursors, malformedExceptionHandler);
    }

    private <ReturnType extends SchemaRule> Iterator<ReturnType> loadAllSchemaRules(final Class<ReturnType> returnType, final SchemaStore35StoreCursors storeCursors, final ThrowingConsumer<Exception, RuntimeException> malformedExceptionHandler) {
        return new PrefetchingIterator<ReturnType>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            private final DynamicRecord record;
            {
                this.highestId = SchemaStorage35.this.schemaStore.getHighestPossibleIdInUse(CursorContext.NULL);
                this.currentId = 1L;
                this.scratchData = SchemaStorage35.this.newRecordBuffer();
                this.record = SchemaStorage35.this.schemaStore.newRecord();
            }

            protected ReturnType fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    try {
                        long id;
                        ++this.currentId;
                        SchemaStorage35.this.schemaStore.getRecordByCursor(id, this.record, RecordLoad.LENIENT_CHECK, storeCursors.readCursor(RecordCursorTypes.SCHEMA_CURSOR));
                        if (!this.record.inUse()) continue;
                        SchemaStorage35.this.schemaStore.getRecordByCursor(id, this.record, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.SCHEMA_CURSOR));
                        if (!this.record.isStartRecord()) continue;
                        try {
                            List<DynamicRecord> records;
                            try {
                                records = SchemaStorage35.this.schemaStore.getRecords(id, RecordLoad.NORMAL, false, storeCursors.readCursor(RecordCursorTypes.SCHEMA_CURSOR));
                            }
                            catch (InvalidRecordException e) {
                                continue;
                            }
                            SchemaRule schemaRule = SchemaStore35.readSchemaRule(id, records, this.scratchData);
                            if (!returnType.isInstance(schemaRule)) continue;
                            return (SchemaRule)returnType.cast(schemaRule);
                        }
                        catch (MalformedSchemaRuleException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Exception e) {
                        malformedExceptionHandler.accept((Object)e);
                    }
                }
                return null;
            }
        };
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }
}

