/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class ArithmeticException
extends Neo4jException {
    private ArithmeticException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    private ArithmeticException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static ArithmeticException longOverflow(String value, String operation) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, "long overflow");
    }

    public static ArithmeticException integerOverflow(String value, String operation, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, String.format("Integer overflow, cannot count to number larger than %s", Long.MAX_VALUE), cause);
    }

    public static ArithmeticException floatOverflow(String value, String operation) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, value + " caused an overflow.");
    }

    public static ArithmeticException numericValueOutOfRange(String value, String operation) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, "numeric value out of range");
    }

    public static ArithmeticException numericValueOutOfRangeWithCause(String value, String operation, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, "numeric value out of range", cause);
    }

    public static ArithmeticException divisionByZero() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22012).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, "/ by zero").build()).build();
        return new ArithmeticException(gql, "/ by zero");
    }

    public static ArithmeticException wrappedArithmeticException(String value, String operation, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, value).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N28).withParam(GqlParams.StringParam.operation, operation).build()).build();
        return new ArithmeticException(gql, cause.getMessage(), cause);
    }

    public Status status() {
        return Status.Statement.ArithmeticError;
    }
}

