/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.NotificationSeverity;

public record InternalNotificationSeverity(Type type, int level) implements NotificationSeverity
{
    public InternalNotificationSeverity {
        Objects.requireNonNull(type, "type must not be null");
    }

    @Override
    public int compareTo(NotificationSeverity severity) {
        return Integer.compare(this.level, ((InternalNotificationSeverity)severity).level());
    }

    public static Optional<NotificationSeverity> valueOf(String value) {
        return Arrays.stream(Type.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> NotificationSeverity.INFORMATION;
            case 1 -> NotificationSeverity.WARNING;
            case 2 -> NotificationSeverity.OFF;
        });
    }

    public static enum Type {
        INFORMATION,
        WARNING,
        OFF;

    }
}

