/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Flow;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.reactive.AbstractReactiveSession;
import org.neo4j.driver.internal.reactive.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactive.DelegatingReactiveTransactionContext;
import org.neo4j.driver.internal.reactive.InternalReactiveResult;
import org.neo4j.driver.internal.reactive.InternalReactiveTransaction;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveSession;
import org.neo4j.driver.reactive.ReactiveTransaction;
import org.neo4j.driver.reactive.ReactiveTransactionCallback;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;

public class InternalReactiveSession
extends AbstractReactiveSession<ReactiveTransaction>
implements ReactiveSession,
BaseReactiveQueryRunner {
    private final DriverObservationProvider observationProvider;

    public InternalReactiveSession(NetworkSession session, DriverObservationProvider observationProvider) {
        super(session);
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    protected ReactiveTransaction createTransaction(UnmanagedTransaction unmanagedTransaction) {
        return new InternalReactiveTransaction(unmanagedTransaction, this.observationProvider);
    }

    @Override
    protected Publisher<Void> closeTransaction(ReactiveTransaction transaction, boolean commit, Observation parentObservation) {
        return ((InternalReactiveTransaction)transaction).close(commit, parentObservation);
    }

    @Override
    public Flow.Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config) {
        Observation beginObservation = this.observationProvider.beginTransaction(ReactiveTransaction.class);
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(beginObservation, this.beginTransaction(config, null, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION), beginObservation)));
    }

    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork, Observation parentObservation) {
        return this.doBeginTransaction(config, txType, apiTelemetryWork, parentObservation);
    }

    @Override
    public <T> Flow.Publisher<T> executeRead(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback, TransactionConfig config) {
        return JdkFlowAdapter.publisherToFlowPublisher(this.runTransaction(AccessMode.READ, tx -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)))), config, ReactiveSession.class, this.observationProvider));
    }

    @Override
    public <T> Flow.Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback, TransactionConfig config) {
        return JdkFlowAdapter.publisherToFlowPublisher(this.runTransaction(AccessMode.WRITE, tx -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)))), config, ReactiveSession.class, this.observationProvider));
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query, TransactionConfig config) {
        Observation runObservation = this.observationProvider.sessionRun(ReactiveSession.class, query.text(), query.parameters());
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(runObservation, this.run(query, config, result -> new InternalReactiveResult((RxResultCursor)result, this.observationProvider), runObservation)));
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    @Override
    public <T> Flow.Publisher<T> close() {
        Observation closeObservation = this.observationProvider.sessionClose(ReactiveSession.class);
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(closeObservation, this.doClose(closeObservation)));
    }
}

