/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.lang.reflect.InvocationTargetException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ValueAdapter;

public class UnsupportedDateTimeValue
extends ValueAdapter {
    final DateTimeException exception;

    public UnsupportedDateTimeValue(DateTimeException exception) {
        this.exception = exception;
    }

    @Override
    public OffsetDateTime asOffsetDateTime() {
        throw this.instantiateDateTimeException();
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        throw this.instantiateDateTimeException();
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    @Override
    public Object asObject() {
        throw this.instantiateDateTimeException();
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.DATE_TIME();
    }

    public Type boltValueType() {
        return Type.DATE_TIME;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "Unsupported datetime value.";
    }

    private DateTimeException instantiateDateTimeException() {
        DateTimeException newException;
        try {
            newException = (DateTimeException)this.exception.getClass().getDeclaredConstructor(String.class, Throwable.class).newInstance(this.exception.getMessage(), this.exception);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            newException = new DateTimeException(this.exception.getMessage(), this.exception);
        }
        return newException;
    }
}

