/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.function.Consumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public abstract class RelationshipValue
extends VirtualRelationshipValue
implements RelationshipVisitor {
    private final long id;
    private long startNodeId;
    private long endNodeId;
    private int type = -1;
    private static final long DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectRelationshipValue.class);

    protected RelationshipValue(long id, long startNodeId, long endNodeId) {
        this.id = id;
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeRelationshipReference(this.id);
        } else {
            writer.writeRelationship(this.elementId(), this.id, this.startNodeElementId(), this.startNode().id(), this.endNodeElementId(), this.endNode().id(), this.type(), this.properties(), this.isDeleted());
        }
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    public long startNodeId() {
        return this.startNodeId;
    }

    public String startNodeElementId() {
        return this.startNode().elementId();
    }

    @Override
    public long startNodeId(Consumer<RelationshipVisitor> consumer) {
        if (this.startNodeId == -1L) {
            consumer.accept(this);
        }
        return this.startNodeId;
    }

    public long endNodeId() {
        return this.endNodeId;
    }

    public String endNodeElementId() {
        return this.endNode().elementId();
    }

    @Override
    public long endNodeId(Consumer<RelationshipVisitor> consumer) {
        if (this.endNodeId == -1L) {
            consumer.accept(this);
        }
        return this.endNodeId;
    }

    public abstract VirtualNodeReference startNode();

    public abstract VirtualNodeReference endNode();

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int relationshipTypeId(Consumer<RelationshipVisitor> consumer) {
        if (this.type == -1) {
            consumer.accept(this);
        }
        return this.type;
    }

    public abstract TextValue type();

    public abstract MapValue properties();

    public abstract String elementId();

    public VirtualNodeValue otherNode(VirtualNodeValue node) {
        return node.equals(this.startNode()) ? this.endNode() : this.startNode();
    }

    public long otherNodeId(long node) {
        return node == this.startNodeId() ? this.endNodeId() : this.startNodeId();
    }

    @Override
    public String getTypeName() {
        return "Relationship";
    }

    @Override
    public void visit(long startNode, long endNode, int type) {
        this.type = type;
        this.startNodeId = startNode;
        this.endNodeId = endNode;
    }

    public static class DirectRelationshipValue
    extends RelationshipValue {
        private final String elementId;
        private final VirtualNodeReference startNode;
        private final VirtualNodeReference endNode;
        private final TextValue type;
        private final MapValue properties;
        private final boolean isDeleted;

        DirectRelationshipValue(long id, String elementId, VirtualNodeReference startNode, VirtualNodeReference endNode, TextValue type, MapValue properties, boolean isDeleted) {
            super(id, startNode.id(), endNode.id());
            assert (properties != null);
            assert (elementId != null);
            this.elementId = elementId;
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
            this.properties = properties;
            this.isDeleted = isDeleted;
        }

        @Override
        public VirtualNodeReference startNode() {
            return this.startNode;
        }

        @Override
        public VirtualNodeReference endNode() {
            return this.endNode;
        }

        @Override
        public TextValue type() {
            return this.type;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }

        public long estimatedHeapUsage() {
            return DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE + this.startNode.estimatedHeapUsage() + this.endNode.estimatedHeapUsage() + this.type.estimatedHeapUsage() + this.properties.estimatedHeapUsage();
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @Override
        public String elementId() {
            return this.elementId;
        }
    }
}

