/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.time.Duration;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LiteralBase;

final class DurationLiteral
extends LiteralBase<Duration> {
    private DurationLiteral(Duration content) {
        super(content);
    }

    static Literal<Duration> of(Duration duration) {
        return new DurationLiteral(duration);
    }

    @Override
    public Duration getContent() {
        return (Duration)this.content;
    }

    @Override
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append("duration('P");
        if (((Duration)this.content).toDaysPart() != 0L) {
            result.append(((Duration)this.content).toDaysPart()).append("D");
        }
        int hours = ((Duration)this.content).toHoursPart();
        int minutes = ((Duration)this.content).toMinutesPart();
        int seconds = ((Duration)this.content).toSecondsPart();
        int nanos = ((Duration)this.content).toNanosPart();
        if (hours != 0 || minutes != 0 || seconds != 0 || nanos != 0) {
            result.append("T");
        }
        if (hours != 0) {
            result.append(hours).append("H");
        }
        if (minutes != 0) {
            result.append(minutes).append("M");
        }
        if (seconds != 0 || nanos != 0) {
            if (nanos == 0) {
                result.append(seconds);
            } else {
                result.append((double)seconds + (double)nanos / 1.0E9);
            }
            result.append("S");
        }
        result.append("')");
        return result.toString();
    }
}

