/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.INTERNAL, since="2023.1.0")
record ImportingWith(With imports, With renames) implements Visitable
{
    ImportingWith() {
        this(null, null);
    }

    static ImportingWith of(IdentifiableElement ... imports) {
        ExpressionList returnItems = new ExpressionList(Arrays.stream(imports).map(i -> {
            if (i instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)i;
                Expression delegate = aliasedExpression.getDelegate();
                if (delegate instanceof Literal) {
                    return null;
                }
                return delegate;
            }
            return i.asExpression();
        }).filter(Objects::nonNull).toList());
        With optionalImports = returnItems.isEmpty() ? null : new With(false, returnItems, null, null, null, null);
        returnItems = new ExpressionList(Arrays.stream(imports).filter(AliasedExpression.class::isInstance).map(Expression.class::cast).toList());
        With optionalRenames = returnItems.isEmpty() ? null : new With(false, returnItems, null, null, null, null);
        return new ImportingWith(optionalImports, optionalRenames);
    }

    @Override
    public void accept(Visitor visitor) {
        Visitable.visitIfNotNull(this.imports, visitor);
        Visitable.visitIfNotNull(this.renames, visitor);
    }
}

