/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.neo4j.cypherdsl.core.ConflictingParametersException;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.ConstantParameterHolder;
import org.neo4j.cypherdsl.core.internal.NameResolvingStrategy;

final class ParameterCollectingVisitor
implements Visitor {
    final Map<String, String> parameterMapping = new TreeMap<String, String>();
    private final StatementContext statementContext;
    private final boolean renderConstantsAsParameters;
    private final Set<String> parameterNames = new TreeSet<String>();
    private final Map<String, Object> parameterValues = new TreeMap<String, Object>();
    private final Map<String, Set<Object>> erroneousParameters = new TreeMap<String, Set<Object>>();
    private final NameResolvingStrategy nameGenerator;

    ParameterCollectingVisitor(StatementContext statementContext, boolean renderConstantsAsParameters) {
        this.statementContext = statementContext;
        this.nameGenerator = NameResolvingStrategy.useGeneratedParameterNames(statementContext);
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }

    @Override
    public void enter(Visitable segment) {
        Object oldValue;
        boolean knownParameterName;
        if (!(segment instanceof Parameter)) {
            return;
        }
        Parameter parameter = (Parameter)segment;
        String parameterName = this.statementContext.getParameterName(parameter);
        Object newValue = parameter.getValue();
        if (newValue instanceof ConstantParameterHolder) {
            ConstantParameterHolder constantParameterHolder = (ConstantParameterHolder)newValue;
            if (!this.renderConstantsAsParameters) {
                return;
            }
            newValue = constantParameterHolder.getValue();
        }
        boolean bl = knownParameterName = !this.parameterNames.add(parameterName);
        if (!knownParameterName && !parameter.isAnon()) {
            this.parameterMapping.put(parameterName, this.nameGenerator.resolve(parameter));
        }
        Object object = oldValue = knownParameterName && this.parameterValues.containsKey(parameterName) ? this.parameterValues.get(parameterName) : Parameter.NO_VALUE;
        if (parameter.hasValue()) {
            this.parameterValues.put(parameterName, newValue);
        }
        if (knownParameterName && !Objects.equals(oldValue, newValue)) {
            Set conflictingObjects = this.erroneousParameters.computeIfAbsent(parameterName, s -> {
                HashSet<Object> list = new HashSet<Object>();
                list.add(oldValue);
                return list;
            });
            conflictingObjects.add(newValue);
        }
    }

    ParameterInformation getResult() {
        if (!this.erroneousParameters.isEmpty()) {
            throw new ConflictingParametersException(this.erroneousParameters);
        }
        return new ParameterInformation(this.parameterNames, this.parameterValues, this.parameterMapping);
    }

    static final class ParameterInformation {
        final Set<String> names;
        final Map<String, Object> values;
        final Map<String, String> renames;

        ParameterInformation(Set<String> names, Map<String, Object> values, Map<String, String> renames) {
            this.names = Collections.unmodifiableSet(names);
            this.values = Collections.unmodifiableMap(values);
            this.renames = Collections.unmodifiableMap(renames);
        }
    }
}

