/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collection;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.ExposesAndThen;
import org.neo4j.cypherdsl.core.ExposesCall;
import org.neo4j.cypherdsl.core.ExposesCreate;
import org.neo4j.cypherdsl.core.ExposesFinish;
import org.neo4j.cypherdsl.core.ExposesHints;
import org.neo4j.cypherdsl.core.ExposesLoadCSV;
import org.neo4j.cypherdsl.core.ExposesLogicalOperators;
import org.neo4j.cypherdsl.core.ExposesMatch;
import org.neo4j.cypherdsl.core.ExposesMerge;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.ExposesUnwind;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.ExposesWith;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.annotations.CheckReturnValue;
import org.neo4j.cypherdsl.core.internal.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface StatementBuilder
extends ExposesMatch,
ExposesCreate,
ExposesMerge,
ExposesUnwind,
ExposesReturning,
ExposesFinish,
ExposesSubqueryCall,
ExposesWith {

    public static interface OngoingInQueryCallWithReturnFields
    extends ExposesMatch,
    ExposesWhere<OngoingReadingWithWhere>,
    ExposesReturning,
    ExposesFinish,
    ExposesWith,
    ExposesSubqueryCall,
    ExposesForeach {
    }

    public static interface VoidCall
    extends OngoingReading {
    }

    public static interface OngoingInQueryCallWithArguments
    extends ExposesCall.ExposesYield<OngoingInQueryCallWithReturnFields> {
        public VoidCall withoutResults();
    }

    public static interface OngoingInQueryCallWithoutArguments
    extends ExposesCall.ExposesWithArgs<OngoingInQueryCallWithArguments>,
    ExposesCall.ExposesYield<OngoingInQueryCallWithReturnFields> {
        public VoidCall withoutResults();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OngoingStandaloneCallWithReturnFields
    extends BuildableStatement<Statement>,
    ExposesMatch,
    ExposesWhere<OngoingReadingWithWhere>,
    ExposesReturning,
    ExposesFinish,
    ExposesWith,
    ExposesSubqueryCall,
    ExposesAndThen<OngoingStandaloneCallWithReturnFields, Statement> {
    }

    public static interface OngoingStandaloneCallWithArguments
    extends BuildableStatement<Statement>,
    ExposesCall.ExposesYield<OngoingStandaloneCallWithReturnFields>,
    ExposesCall.AsFunction,
    ExposesYieldStar {
        public VoidCall withoutResults();
    }

    public static interface OngoingStandaloneCallWithoutArguments
    extends BuildableStatement<Statement>,
    ExposesCall.ExposesWithArgs<OngoingStandaloneCallWithArguments>,
    ExposesCall.ExposesYield<OngoingStandaloneCallWithReturnFields>,
    ExposesCall.AsFunction,
    ExposesYieldStar {
        public VoidCall withoutResults();
    }

    public static interface ExposesYieldStar {
        public OngoingStandaloneCallWithReturnFields yield(Asterisk var1);

        default public OngoingStandaloneCallWithReturnFields yieldStar() {
            return this.yield(Cypher.asterisk());
        }
    }

    public static interface OngoingMergeAction
    extends ExposesSetLabel<BuildableOngoingMergeAction> {
        @CheckReturnValue
        public BuildableOngoingMergeAction set(Expression ... var1);

        @CheckReturnValue
        public BuildableOngoingMergeAction set(Collection<? extends Expression> var1);

        @CheckReturnValue
        default public BuildableOngoingMergeAction set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }

        @CheckReturnValue
        public BuildableOngoingMergeAction mutate(Expression var1, Expression var2);

        @CheckReturnValue
        default public BuildableOngoingMergeAction mutate(Named variable, Expression properties) {
            return this.mutate(variable.getRequiredSymbolicName(), properties);
        }
    }

    public static interface BuildableOngoingMergeAction
    extends BuildableMatchAndUpdate,
    ExposesMergeAction {
    }

    public static interface ExposesMergeAction {
        @CheckReturnValue
        public OngoingMergeAction onCreate();

        @CheckReturnValue
        public OngoingMergeAction onMatch();
    }

    public static interface BuildableMatchAndUpdate
    extends OngoingMatchAndUpdate,
    BuildableStatement<Statement> {
    }

    public static interface OngoingMatchAndUpdate
    extends ExposesReturning,
    ExposesFinish,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesCreate {
    }

    public static interface ExposesSetAndRemove
    extends ExposesSet,
    ExposesSetLabel<BuildableMatchAndUpdate> {
        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Node var1, String ... var2);

        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Node var1, Collection<String> var2);

        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Property ... var1);

        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Collection<Property> var1);
    }

    public static interface ExposesSetLabel<R> {
        @CheckReturnValue
        public R set(Node var1, String ... var2);

        @CheckReturnValue
        public R set(Node var1, Collection<String> var2);
    }

    public static interface ExposesSet {
        @CheckReturnValue
        public BuildableMatchAndUpdate set(Expression ... var1);

        @CheckReturnValue
        public BuildableMatchAndUpdate set(Collection<? extends Expression> var1);

        @CheckReturnValue
        default public BuildableMatchAndUpdate set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }

        @CheckReturnValue
        public BuildableMatchAndUpdate mutate(Expression var1, Expression var2);

        @CheckReturnValue
        default public BuildableMatchAndUpdate mutate(Named variable, Expression properties) {
            return this.mutate(variable.getRequiredSymbolicName(), properties);
        }
    }

    public static interface ExposesDelete {
        @CheckReturnValue
        default public OngoingUpdate delete(String ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        @CheckReturnValue
        default public OngoingUpdate delete(Named ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        @CheckReturnValue
        public OngoingUpdate delete(Expression ... var1);

        @CheckReturnValue
        public OngoingUpdate delete(Collection<? extends Expression> var1);

        @CheckReturnValue
        default public OngoingUpdate detachDelete(String ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        @CheckReturnValue
        default public OngoingUpdate detachDelete(Named ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        @CheckReturnValue
        public OngoingUpdate detachDelete(Expression ... var1);

        @CheckReturnValue
        public OngoingUpdate detachDelete(Collection<? extends Expression> var1);
    }

    public static interface ExposesUpdatingClause
    extends ExposesDelete,
    ExposesMerge,
    ExposesSetAndRemove,
    ExposesForeach {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ForeachUpdateStep {
        public OngoingUpdate apply(UpdatingClause ... var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ForeachSourceStep {
        public ForeachUpdateStep in(Expression var1);
    }

    public static interface ExposesForeach {
        public ForeachSourceStep foreach(SymbolicName var1);
    }

    public static interface ExposesLimit {
        @CheckReturnValue
        public OngoingReadingAndWith limit(Number var1);

        @CheckReturnValue
        public OngoingReadingAndWith limit(Expression var1);
    }

    public static interface ExposesSkip {
        @CheckReturnValue
        public OngoingReadingAndWithWithSkip skip(Number var1);

        @CheckReturnValue
        public OngoingReadingAndWithWithSkip skip(Expression var1);
    }

    public static interface OngoingReadingAndWithWithSkip
    extends OngoingReadingAndWith,
    ExposesLimit {
    }

    public static interface ExposesOrderBy {
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... var1);

        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithWhere orderBy(Collection<SortItem> var1);

        @CheckReturnValue
        public OngoingOrderDefinition orderBy(Expression var1);
    }

    public static interface Terminal
    extends BuildableStatement<Statement> {
    }

    public static interface TerminalExposesLimit
    extends BuildableStatement<ResultStatement> {
        @CheckReturnValue
        public BuildableStatement<ResultStatement> limit(Number var1);

        @CheckReturnValue
        public BuildableStatement<ResultStatement> limit(Expression var1);
    }

    public static interface TerminalExposesSkip {
        @CheckReturnValue
        public TerminalExposesLimit skip(Number var1);

        @CheckReturnValue
        public TerminalExposesLimit skip(Expression var1);
    }

    public static interface TerminalExposesOrderBy {
        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder orderBy(SortItem ... var1);

        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder orderBy(Collection<SortItem> var1);

        @CheckReturnValue
        public TerminalOngoingOrderDefinition orderBy(Expression var1);
    }

    public static interface BuildableStatement<T extends Statement> {
        public T build();

        default public Statement explain() {
            return DecoratedQuery.explain(this.build());
        }

        default public Statement profile() {
            return DecoratedQuery.profile(this.build());
        }
    }

    public static interface OngoingOrderDefinition
    extends ExposesSkip,
    ExposesLimit {
        @CheckReturnValue
        public OngoingReadingAndWithWithWhereAndOrder descending();

        @CheckReturnValue
        public OngoingReadingAndWithWithWhereAndOrder ascending();
    }

    public static interface OngoingReadingAndWithWithWhereAndOrder
    extends ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
        @CheckReturnValue
        public OngoingOrderDefinition and(Expression var1);
    }

    public static interface TerminalOngoingOrderDefinition
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement<ResultStatement> {
        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder descending();

        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder ascending();
    }

    public static interface OngoingMatchAndReturnWithOrder
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement<ResultStatement> {
        @CheckReturnValue
        public TerminalOngoingOrderDefinition and(Expression var1);
    }

    public static interface OrderableOngoingReadingAndWith
    extends ExposesOrderBy,
    ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
        public Collection<Expression> getIdentifiableExpressions();
    }

    public static interface OngoingReadingAndWith
    extends OngoingReading,
    ExposesMatch,
    ExposesLoadCSV {
    }

    public static interface OrderableOngoingReadingAndWithWithWhere
    extends OrderableOngoingReadingAndWith,
    ExposesLogicalOperators<OrderableOngoingReadingAndWithWithWhere> {
    }

    public static interface OrderableOngoingReadingAndWithWithoutWhere
    extends OrderableOngoingReadingAndWith {
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithWhere where(Condition var1);

        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithWhere where(RelationshipPattern pathPattern) {
            Assertions.notNull(pathPattern, "The path pattern must not be null.");
            return this.where(RelationshipPatternCondition.of(pathPattern));
        }
    }

    public static interface OngoingReadingAndReturn
    extends TerminalExposesOrderBy,
    TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement<ResultStatement> {
        public Collection<Expression> getIdentifiableExpressions();
    }

    public static interface OngoingUnwind {
        @CheckReturnValue
        public OngoingReading as(String var1);

        @CheckReturnValue
        default public OngoingReading as(SymbolicName variable) {
            return this.as(variable.getValue());
        }
    }

    public static interface OngoingReading
    extends ExposesReturning,
    ExposesFinish,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesUnwind,
    ExposesCreate,
    ExposesMatch,
    ExposesCall<OngoingInQueryCallWithoutArguments>,
    ExposesSubqueryCall {
    }

    public static interface OngoingReadingWithWhere
    extends OngoingReading,
    ExposesMatch,
    ExposesLogicalOperators<OngoingReadingWithWhere>,
    ExposesExistentialSubqueryCall {
    }

    public static interface OngoingReadingWithoutWhere
    extends OngoingReading,
    ExposesHints,
    ExposesWhere<OngoingReadingWithWhere>,
    ExposesMatch,
    ExposesExistentialSubqueryCall {
    }

    public static interface ExposesExistentialSubqueryCall {
        @Neo4jVersion(minimum="4.0.0")
        public Condition asCondition();
    }

    public static interface OngoingMerge
    extends OngoingUpdate,
    ExposesMergeAction,
    ExposesSetAndRemove {
    }

    public static interface OngoingUpdate
    extends BuildableStatement<Statement>,
    ExposesCreate,
    ExposesMerge,
    ExposesDelete,
    ExposesReturning,
    ExposesFinish,
    ExposesWith,
    ExposesSet,
    ExposesForeach {
    }
}

