/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.Namespace;

@API(status=API.Status.INTERNAL, since="2020.0.1")
public final class ProcedureName
implements Visitable {
    private final Namespace optionalNamespace;
    private final String value;

    private ProcedureName(String value) {
        this(null, value);
    }

    private ProcedureName(Namespace namespace, String value) {
        this.optionalNamespace = namespace;
        this.value = value;
    }

    public static ProcedureName from(String ... namespaceAndProcedure) {
        if (namespaceAndProcedure.length == 1) {
            return new ProcedureName(namespaceAndProcedure[0]);
        }
        Namespace namespace = new Namespace(Arrays.copyOf(namespaceAndProcedure, namespaceAndProcedure.length - 1));
        return new ProcedureName(namespace, namespaceAndProcedure[namespaceAndProcedure.length - 1]);
    }

    public static ProcedureName from(List<String> namespace, String procedure) {
        if (namespace.isEmpty()) {
            return new ProcedureName(procedure);
        }
        return new ProcedureName(new Namespace(namespace.toArray(new String[0])), procedure);
    }

    public String getQualifiedName() {
        Object namespace = "";
        if (this.optionalNamespace != null) {
            namespace = this.optionalNamespace.asString() + ".";
        }
        return (String)namespace + this.value;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.optionalNamespace, visitor);
        visitor.leave(this);
    }

    public String getValue() {
        return this.value;
    }
}

