/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.PrintStream;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Environment;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.completions.CompletionEngine;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.completions.DbInfoImpl;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.prettyprint.PrettyPrinter;
import org.neo4j.shell.printer.AnsiPrinter;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.CypherShellTerminalBuilder;
import org.neo4j.shell.terminal.SimplePrompt;
import org.neo4j.shell.util.Versions;
import org.neo4j.util.VisibleForTesting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Main
implements AutoCloseable {
    private static final Logger log = Logger.create();
    public static final int EXIT_FAILURE = 1;
    public static final int EXIT_SUCCESS = 0;
    static final String NEO_CLIENT_ERROR_SECURITY_UNAUTHORIZED = "Neo.ClientError.Security.Unauthorized";
    private final CliArgs args;
    private final Printer printer;
    private final CypherShell shell;
    private final boolean isOutputInteractive;
    private final ShellRunner.Factory runnerFactory;
    private final CypherShellTerminal terminal;
    private final StatementParser statementParser = new ShellStatementParser();
    private final ParameterService parameters;

    public Main(CliArgs args) {
        boolean isInteractive = !args.getNonInteractive() && ShellRunner.isInputInteractive();
        this.printer = new AnsiPrinter(Format.VERBOSE, args.getErrorFormat(), System.out, System.err);
        this.args = args;
        BoltStateHandler boltStateHandler = new BoltStateHandler(ShellRunner.shouldBeInteractive(args, isInteractive), args.getAccessMode());
        boolean completionsEnabledByConfig = args.getEnableAutocompletions();
        this.parameters = ParameterService.create(boltStateHandler);
        DbInfoImpl dbInfo = new DbInfoImpl(this.parameters, boltStateHandler, completionsEnabledByConfig);
        CompletionEngine completionEngine = new CompletionEngine(dbInfo, boltStateHandler);
        this.terminal = CypherShellTerminalBuilder.terminalBuilder().interactive(isInteractive).logger(this.printer).parameters(this.parameters).idleTimeout(args.getIdleTimeout(), args.getIdleTimeoutDelay()).enableHistory(args.getHistoryBehaviour().historyEnabled()).build(dbInfo, completionEngine);
        this.shell = new CypherShell(this.printer, boltStateHandler, dbInfo, new PrettyPrinter(PrettyConfig.from(args, isInteractive)), this.parameters);
        this.isOutputInteractive = !args.getNonInteractive() && ShellRunner.isOutputInteractive();
        this.runnerFactory = new ShellRunner.Factory();
    }

    @VisibleForTesting
    public Main(CliArgs args, PrintStream out, PrintStream err, boolean outputInteractive, CypherShellTerminal terminal, BoltStateHandler boltStateHandler, DbInfo dbInfo, ParameterService parameters) {
        this.terminal = terminal;
        this.args = args;
        this.printer = new AnsiPrinter(Format.VERBOSE, args.getErrorFormat(), out, err);
        boolean isInteractive = ShellRunner.shouldBeInteractive(args, terminal.isInteractive());
        this.parameters = parameters;
        this.shell = new CypherShell(this.printer, boltStateHandler, dbInfo, new PrettyPrinter(PrettyConfig.from(args, isInteractive)), parameters);
        this.isOutputInteractive = outputInteractive;
        this.runnerFactory = new ShellRunner.Factory();
    }

    @VisibleForTesting
    public Main(CliArgs args, AnsiPrinter logger, CypherShell shell, ParameterService parameters, boolean outputInteractive, ShellRunner.Factory runnerFactory, CypherShellTerminal terminal) {
        this.terminal = terminal;
        this.args = args;
        this.printer = logger;
        this.shell = shell;
        this.isOutputInteractive = outputInteractive;
        this.runnerFactory = runnerFactory;
        this.parameters = parameters;
    }

    public static void main(String[] args) {
        int exitCode;
        CliArgs cliArgs = new CliArgHelper(new Environment()).parse(args);
        if (cliArgs == null) {
            System.exit(1);
        }
        Logger.setupLogging(cliArgs);
        try (Main main = new Main(cliArgs);){
            exitCode = main.startShell();
        }
        System.exit(exitCode);
    }

    public int startShell() {
        if (this.args.getVersion()) {
            this.terminal.write().println("Cypher-Shell " + Build.version());
            return 0;
        }
        if (this.args.getDriverVersion()) {
            this.terminal.write().println("Neo4j Driver " + Build.driverVersion());
            return 0;
        }
        if (this.args.getChangePassword()) {
            return this.runSetNewPassword();
        }
        return this.runShell();
    }

    private int runSetNewPassword() {
        try {
            this.promptAndChangePassword(this.args.connectionConfig(), null);
        }
        catch (Exception e) {
            log.error(e);
            this.printer.printError("Failed to change password: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int runShell() {
        ConnectionConfig connectionConfig = this.args.connectionConfig();
        try {
            if (this.args.getCypher().isPresent()) {
                this.connectMaybeInteractively(connectionConfig);
                this.shell.execute(this.statementParser.parse(this.args.getCypher().get()).statements());
                return 0;
            }
            this.connectMaybeInteractively(connectionConfig);
            ShellRunner shellRunner = this.runnerFactory.create(this.args, this.shell, this.printer, this.terminal);
            CommandHelper commandHelper = new CommandHelper(this.printer, shellRunner.getHistorian(), this.shell, this.terminal, this.parameters);
            this.shell.setCommandHelper(commandHelper);
            this.shell.printFallbackWarning(connectionConfig.uri());
            if (shellRunner.isInteractive() || this.args.getFormat() == Format.VERBOSE) {
                this.shell.printLicenseWarnings();
            }
            return shellRunner.runUntilEnd();
        }
        catch (Throwable e) {
            log.error(e);
            this.printer.printError(e);
            return 1;
        }
    }

    private void connectMaybeInteractively(ConnectionConfig connectionConfig) throws Exception {
        boolean didPrompt = false;
        if (this.terminal.isInteractive() && !connectionConfig.username().isEmpty() && connectionConfig.password().isEmpty()) {
            connectionConfig = this.promptForUsernameAndPassword(connectionConfig);
            didPrompt = true;
        }
        while (true) {
            try {
                this.shell.connect(connectionConfig);
                this.setArgumentParameters();
                return;
            }
            catch (AuthenticationException e) {
                if (didPrompt || !this.terminal.isInteractive() || !connectionConfig.username().isEmpty() && !connectionConfig.password().isEmpty()) {
                    log.error("Failed to connect", e);
                    throw e;
                }
                log.info("Failed to connect, prompting for user name and password...");
                connectionConfig = this.promptForUsernameAndPassword(connectionConfig);
                didPrompt = true;
                continue;
            }
            catch (Neo4jException e) {
                if (this.terminal.isInteractive() && Versions.isPasswordChangeRequiredException(e)) {
                    connectionConfig = this.promptAndChangePassword(connectionConfig, "Password change required");
                    didPrompt = true;
                    continue;
                }
                log.error("Failed to connect", e);
                throw e;
            }
            break;
        }
    }

    private void setArgumentParameters() throws CommandException {
        for (ParameterService.RawParameters parameter : this.args.getParameters()) {
            this.parameters.setParameters(this.parameters.evaluate(parameter));
        }
    }

    private ConnectionConfig promptForUsernameAndPassword(ConnectionConfig connectionConfig) throws Exception {
        String username = connectionConfig.username();
        String password = connectionConfig.password();
        if (username.isEmpty()) {
            String string = username = this.isOutputInteractive ? this.promptForNonEmptyText("username", false) : this.promptForText("username", false);
        }
        if (password.isEmpty()) {
            password = this.promptForText("password", true);
        }
        return connectionConfig.withUsernameAndPassword(username, password);
    }

    private ConnectionConfig promptAndChangePassword(ConnectionConfig connectionConfig, String message) throws Exception {
        String password;
        String username;
        log.info("Password change triggered.");
        if (message != null) {
            this.terminal.write().println(message);
        }
        if ((username = connectionConfig.username()).isEmpty()) {
            String string = username = this.isOutputInteractive ? this.promptForNonEmptyText("username", false) : this.promptForText("username", false);
        }
        if ((password = connectionConfig.password()).isEmpty()) {
            password = this.promptForText("password", true);
        }
        connectionConfig = connectionConfig.withUsernameAndPassword(username, password);
        String newPassword = this.isOutputInteractive ? this.promptForNonEmptyText("new password", true) : this.promptForText("new password", true);
        String reenteredNewPassword = this.promptForText("confirm password", true);
        if (!reenteredNewPassword.equals(newPassword)) {
            throw new CommandException("Passwords are not matching.");
        }
        this.shell.changePassword(connectionConfig, newPassword);
        return connectionConfig.withPassword(newPassword);
    }

    @VisibleForTesting
    protected CypherShell getCypherShell() {
        return this.shell;
    }

    private String promptForNonEmptyText(String prompt, boolean maskInput) throws Exception {
        String text = this.promptForText(prompt, maskInput);
        while (text.isEmpty()) {
            text = this.promptForText(String.format("%s cannot be empty%n%n%s", prompt, prompt), maskInput);
        }
        return text;
    }

    private String promptForText(String prompt, boolean maskInput) throws CommandException {
        String read;
        try (SimplePrompt simplePrompt = this.terminal.simplePrompt();){
            String promptWithColon = prompt + ": ";
            read = maskInput ? simplePrompt.readPassword(promptWithColon) : simplePrompt.readLine(promptWithColon);
        }
        catch (Exception e) {
            log.error(e);
            throw new CommandException("No text could be read, exiting...");
        }
        if (read == null) {
            throw new CommandException("No text could be read, exiting...");
        }
        return read;
    }

    @Override
    public void close() {
        try {
            this.terminal.close();
            this.shell.disconnect();
        }
        catch (Exception e) {
            log.warn("Failed to exit", e);
        }
    }
}

