/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.terminal.JlineTerminal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StatementJlineParser
extends DefaultParser
implements Parser {
    private static final Logger log = Logger.create();
    private final StatementParser statementParser;
    private boolean enableStatementParsing;

    public StatementJlineParser(StatementParser statementParser) {
        this.statementParser = statementParser;
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        if (!this.enableStatementParsing) {
            return new UnparsedLine(line, cursor);
        }
        if (context == Parser.ParseContext.COMPLETE) {
            return this.parseForCompletion(line, cursor);
        }
        return this.parseForExecution(line, cursor);
    }

    private SimpleParsedStatements parseForExecution(String line, int cursor) {
        StatementParser.ParsedStatements parsed = this.parse(line);
        if (parsed.hasIncompleteStatement()) {
            throw new EOFError(-1, cursor, "Incomplete statement");
        }
        return new SimpleParsedStatements(parsed, line, cursor);
    }

    private ParsedLine parseForCompletion(String line, int cursor) {
        return this.parse(line).statementAtOffset(cursor).flatMap(s -> this.completingStatement((StatementParser.ParsedStatement)s, line, cursor)).orElseGet(() -> new BlankCompletion(line, cursor));
    }

    private Optional<ParsedLine> completingStatement(StatementParser.ParsedStatement statement, String line, int cursor) {
        StatementParser.CommandStatement command;
        if (statement instanceof StatementParser.CommandStatement && (command = (StatementParser.CommandStatement)statement).args().isEmpty()) {
            return Optional.of(new CommandCompletion(command, line, cursor));
        }
        if (statement instanceof StatementParser.CypherStatement) {
            StatementParser.CypherStatement cypher = (StatementParser.CypherStatement)statement;
            return Optional.of(this.completingCypher(cypher, line, cursor));
        }
        return Optional.empty();
    }

    private String findLastToken(String query) {
        if (query.isEmpty()) {
            return "";
        }
        int i = query.length() - 1;
        boolean spaceFound = false;
        while (i >= 0 && !spaceFound) {
            if (Character.isWhitespace(query.charAt(i))) {
                spaceFound = true;
                continue;
            }
            --i;
        }
        return query.substring(i + 1);
    }

    private CypherCompletion completingCypher(StatementParser.CypherStatement statement, String line, int cursor) {
        String word = this.findLastToken(statement.statement());
        return new CypherCompletion(statement, line, cursor, word, 0);
    }

    private StatementParser.ParsedStatements parse(String line) {
        try {
            return this.statementParser.parse(line);
        }
        catch (IOException e) {
            log.error("Failed to parse " + line, e);
            throw new RuntimeException("Failed to parse `" + line + "`: " + e.getMessage(), e);
        }
    }

    public void setEnableStatementParsing(boolean enable) {
        this.enableStatementParsing = enable;
    }

    public boolean isEscapeChar(char ch) {
        return false;
    }

    public boolean validCommandName(String name) {
        return false;
    }

    public boolean validVariableName(String name) {
        return false;
    }

    public String getCommand(String line) {
        return "";
    }

    public String getVariable(String line) {
        return null;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected record UnparsedLine(String line, int cursor) implements NoWordsParsedLine
    {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected record SimpleParsedStatements(StatementParser.ParsedStatements statements, String line, int cursor) implements JlineTerminal.ParsedLineStatements,
    NoWordsParsedLine
    {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static final class CommandCompletion
    extends Record
    implements CompletingWord,
    CompletingStatements {
        private final StatementParser.CommandStatement statement;
        private final String line;
        private final int cursor;

        protected CommandCompletion(StatementParser.CommandStatement statement, String line, int cursor) {
            this.statement = statement;
            this.line = line;
            this.cursor = cursor;
        }

        public String word() {
            return this.statement.name();
        }

        public int wordCursor() {
            return 0;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CommandCompletion.class, "statement;line;cursor", "statement", "line", "cursor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CommandCompletion.class, "statement;line;cursor", "statement", "line", "cursor"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CommandCompletion.class, "statement;line;cursor", "statement", "line", "cursor"}, this, o);
        }

        @Override
        public StatementParser.CommandStatement statement() {
            return this.statement;
        }

        public String line() {
            return this.line;
        }

        public int cursor() {
            return this.cursor;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static final class CypherCompletion
    extends Record
    implements CompletingWord,
    CompletingStatements {
        private final StatementParser.CypherStatement statement;
        private final String line;
        private final int cursor;
        private final String word;
        private final int wordCursor;

        protected CypherCompletion(StatementParser.CypherStatement statement, String line, int cursor, String word, int wordCursor) {
            this.statement = statement;
            this.line = line;
            this.cursor = cursor;
            this.word = word;
            this.wordCursor = wordCursor;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CypherCompletion.class, "statement;line;cursor;word;wordCursor", "statement", "line", "cursor", "word", "wordCursor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CypherCompletion.class, "statement;line;cursor;word;wordCursor", "statement", "line", "cursor", "word", "wordCursor"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CypherCompletion.class, "statement;line;cursor;word;wordCursor", "statement", "line", "cursor", "word", "wordCursor"}, this, o);
        }

        @Override
        public StatementParser.CypherStatement statement() {
            return this.statement;
        }

        public String line() {
            return this.line;
        }

        public int cursor() {
            return this.cursor;
        }

        public String word() {
            return this.word;
        }

        public int wordCursor() {
            return this.wordCursor;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected record BlankCompletion(String line, int cursor) implements NoWordsParsedLine
    {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface CompletingWord
    extends CompletingParsedLine {
        default public CharSequence escape(CharSequence candidate, boolean complete) {
            return candidate;
        }

        default public int rawWordCursor() {
            return this.wordCursor();
        }

        default public int rawWordLength() {
            return this.word().length();
        }

        default public int wordIndex() {
            return 0;
        }

        default public List<String> words() {
            return Collections.singletonList(this.word());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static interface NoWordsParsedLine
    extends CompletingWord {
        default public String word() {
            return "";
        }

        default public int wordCursor() {
            return 0;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface CompletingStatements {
        public StatementParser.ParsedStatement statement();
    }
}

