/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.label_expressions;

import java.io.Serializable;
import org.neo4j.cypher.internal.label_expressions.LabelExpression;
import org.neo4j.cypher.internal.label_expressions.LabelExpressionLeafName;
import org.neo4j.cypher.internal.label_expressions.LazySolvableLabelExpression$;
import org.neo4j.cypher.internal.label_expressions.NodeLabels;
import org.neo4j.cypher.internal.label_expressions.NodeLabels$SomeUnknownLabels$;
import org.neo4j.cypher.internal.label_expressions.SolvableLabelExpression;
import org.neo4j.cypher.internal.util.tailrec.TailCallsUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.TailCalls;
import scala.util.control.TailCalls$;

public final class SolvableLabelExpression$
implements Serializable {
    public static final SolvableLabelExpression$ MODULE$ = new SolvableLabelExpression$();

    public SolvableLabelExpression from(LabelExpression labelExpression) {
        return (SolvableLabelExpression)this.extractLabelExpressionRec(labelExpression).result();
    }

    private TailCalls.TailRec<SolvableLabelExpression> extractLabelExpressionRec(LabelExpression labelExpression) {
        LabelExpression.Disjunctions disjunctions;
        scala.collection.immutable.Seq<LabelExpression> disjointExpressions;
        LabelExpression.Conjunctions conjunctions;
        scala.collection.immutable.Seq<LabelExpression> conjointExpressions;
        LabelExpression.Negation negation;
        LabelExpression not;
        LabelExpression labelExpression2 = labelExpression;
        if (labelExpression2 instanceof LabelExpression.Wildcard) {
            return TailCalls$.MODULE$.done((Object)this.wildcard());
        }
        if (labelExpression2 instanceof LabelExpression.DynamicLeaf) {
            return TailCalls$.MODULE$.done((Object)this.dynamic());
        }
        if (labelExpression2 instanceof LabelExpression.Leaf) {
            LabelExpression.Leaf leaf = (LabelExpression.Leaf)labelExpression2;
            LabelExpressionLeafName label = leaf.name();
            return TailCalls$.MODULE$.done((Object)this.label(label.name()));
        }
        if (labelExpression2 instanceof LabelExpression.Negation && (not = (negation = (LabelExpression.Negation)labelExpression2).e()) != null) {
            LabelExpression labelExpression3 = not;
            return TailCalls$.MODULE$.tailcall((Function0 & Serializable)() -> MODULE$.extractLabelExpressionRec(labelExpression3)).map((Function1 & Serializable)x$5 -> x$5.not());
        }
        if (labelExpression2 instanceof LabelExpression.ColonConjunction) {
            LabelExpression.ColonConjunction colonConjunction = (LabelExpression.ColonConjunction)labelExpression2;
            LabelExpression lhs = colonConjunction.lhs();
            LabelExpression rhs = colonConjunction.rhs();
            if (lhs != null) {
                LabelExpression labelExpression4 = lhs;
                if (rhs != null) {
                    LabelExpression labelExpression5 = rhs;
                    return TailCallsUtil$.MODULE$.map2(this.extractLabelExpressionRec(labelExpression4), this.extractLabelExpressionRec(labelExpression5), (Function2 & Serializable)(x$6, x$7) -> x$6.and((SolvableLabelExpression)x$7));
                }
            }
        }
        if (labelExpression2 instanceof LabelExpression.Conjunctions && (conjointExpressions = (conjunctions = (LabelExpression.Conjunctions)labelExpression2).children()) != null) {
            scala.collection.immutable.Seq<LabelExpression> seq = conjointExpressions;
            return TailCallsUtil$.MODULE$.traverse((Seq)seq.toList(), (Function1 & Serializable)le -> MODULE$.extractLabelExpressionRec((LabelExpression)le)).map((Function1 & Serializable)x$8 -> (SolvableLabelExpression)x$8.reduceLeft((Function2 & Serializable)(x$9, x$10) -> x$9.and((SolvableLabelExpression)x$10)));
        }
        if (labelExpression2 instanceof LabelExpression.ColonDisjunction) {
            LabelExpression.ColonDisjunction colonDisjunction = (LabelExpression.ColonDisjunction)labelExpression2;
            LabelExpression lhs = colonDisjunction.lhs();
            LabelExpression rhs = colonDisjunction.rhs();
            if (lhs != null) {
                LabelExpression labelExpression6 = lhs;
                if (rhs != null) {
                    LabelExpression labelExpression7 = rhs;
                    return TailCallsUtil$.MODULE$.map2(this.extractLabelExpressionRec(labelExpression6), this.extractLabelExpressionRec(labelExpression7), (Function2 & Serializable)(x$11, x$12) -> x$11.or((SolvableLabelExpression)x$12));
                }
            }
        }
        if (labelExpression2 instanceof LabelExpression.Disjunctions && (disjointExpressions = (disjunctions = (LabelExpression.Disjunctions)labelExpression2).children()) != null) {
            scala.collection.immutable.Seq<LabelExpression> seq = disjointExpressions;
            return TailCallsUtil$.MODULE$.traverse((Seq)seq.toList(), (Function1 & Serializable)le -> MODULE$.extractLabelExpressionRec((LabelExpression)le)).map((Function1 & Serializable)x$13 -> (SolvableLabelExpression)x$13.reduceLeft((Function2 & Serializable)(x$14, x$15) -> x$14.or((SolvableLabelExpression)x$15)));
        }
        throw new MatchError((Object)labelExpression2);
    }

    public SolvableLabelExpression build(Set<String> labels, Function1<NodeLabels, Object> matches) {
        return new SolvableLabelExpression(labels, matches);
    }

    public SolvableLabelExpression wildcard() {
        return this.build((Set<String>)Predef$.MODULE$.Set().empty(), (Function1<NodeLabels, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SolvableLabelExpression$.$anonfun$wildcard$1(x0$1)));
    }

    public SolvableLabelExpression dynamic() {
        return this.build((Set<String>)Predef$.MODULE$.Set().empty(), (Function1<NodeLabels, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SolvableLabelExpression$.$anonfun$dynamic$1(x0$1)));
    }

    public SolvableLabelExpression label(String labelName) {
        return this.build((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{labelName}))), (Function1<NodeLabels, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SolvableLabelExpression$.$anonfun$label$1(labelName, x0$1)));
    }

    public LazyList<NodeLabels> allSolutions(scala.collection.immutable.Seq<SolvableLabelExpression> conjointExpressions) {
        return LazySolvableLabelExpression$.MODULE$.fold(conjointExpressions).solutions();
    }

    public SolvableLabelExpression apply(Set<String> allLabels, Function1<NodeLabels, Object> matches) {
        return new SolvableLabelExpression(allLabels, matches);
    }

    public Option<Tuple2<Set<String>, Function1<NodeLabels, Object>>> unapply(SolvableLabelExpression x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.allLabels(), x$0.matches()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SolvableLabelExpression$.class);
    }

    public static final /* synthetic */ boolean $anonfun$wildcard$1(NodeLabels x0$1) {
        NodeLabels nodeLabels = x0$1;
        if (nodeLabels instanceof NodeLabels.KnownLabels) {
            NodeLabels.KnownLabels knownLabels = (NodeLabels.KnownLabels)nodeLabels;
            Set<String> labels = knownLabels.labelNames();
            return labels.nonEmpty();
        }
        if (NodeLabels$SomeUnknownLabels$.MODULE$.equals(nodeLabels)) {
            return true;
        }
        throw new MatchError((Object)nodeLabels);
    }

    public static final /* synthetic */ boolean $anonfun$dynamic$1(NodeLabels x0$1) {
        NodeLabels nodeLabels = x0$1;
        if (nodeLabels instanceof NodeLabels.KnownLabels) {
            NodeLabels.KnownLabels knownLabels = (NodeLabels.KnownLabels)nodeLabels;
            Set<String> labels = knownLabels.labelNames();
            return labels.nonEmpty();
        }
        if (NodeLabels$SomeUnknownLabels$.MODULE$.equals(nodeLabels)) {
            return true;
        }
        throw new MatchError((Object)nodeLabels);
    }

    public static final /* synthetic */ boolean $anonfun$label$1(String labelName$1, NodeLabels x0$1) {
        NodeLabels nodeLabels = x0$1;
        if (nodeLabels instanceof NodeLabels.KnownLabels) {
            NodeLabels.KnownLabels knownLabels = (NodeLabels.KnownLabels)nodeLabels;
            Set<String> labels = knownLabels.labelNames();
            return labels.contains((Object)labelName$1);
        }
        if (NodeLabels$SomeUnknownLabels$.MODULE$.equals(nodeLabels)) {
            return false;
        }
        throw new MatchError((Object)nodeLabels);
    }

    private SolvableLabelExpression$() {
    }
}

