/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.DeduplicateLargeObjectsHeapEstimatorCache;
import org.neo4j.memory.HeapEstimatorCache;

public record HeapEstimatorCacheConfig(int sizeLimit, long largeObjectThreshold) {
    public static final int DEFAULT_SIZE_LIMIT = 16;
    public static final long DEFAULT_LARGE_OBJECT_THRESHOLD = 65536L;
    public static final HeapEstimatorCacheConfig DISABLED = new HeapEstimatorCacheConfig(0, Long.MAX_VALUE);
    public static final HeapEstimatorCacheConfig SMALL = new HeapEstimatorCacheConfig(16, 65536L);
    public static final HeapEstimatorCacheConfig LARGE = new HeapEstimatorCacheConfig(128, 8192L);
    public static final HeapEstimatorCacheConfig DEFAULT = SMALL;

    public HeapEstimatorCache newDefaultHeapEstimatorCache() {
        return this.sizeLimit > 0 ? new DeduplicateLargeObjectsHeapEstimatorCache(this) : HeapEstimatorCache.NoHeapEstimatorCache.INSTANCE;
    }
}

