/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.neo4j.collection.trackable.HeapTracking;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingUnifiedMap<K, V>
extends UnifiedMap<K, V>
implements HeapTracking.Map<K, V> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingUnifiedMap.class);
    private final MemoryTracker memoryTracker;
    private long trackedHeap;

    public static <K, V> HeapTrackingUnifiedMap<K, V> createUnifiedMap(MemoryTracker memoryTracker) {
        int initialSizeToAllocate = 32;
        long trackedHeap = HeapTrackingUnifiedMap.arrayHeapSize(initialSizeToAllocate);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedHeap);
        return new HeapTrackingUnifiedMap<K, V>(memoryTracker, trackedHeap);
    }

    public static <K, V> HeapTrackingUnifiedMap<K, V> createUnifiedMap(int initialCapacity, MemoryTracker memoryTracker) {
        return new HeapTrackingUnifiedMap<K, V>(initialCapacity, memoryTracker);
    }

    private HeapTrackingUnifiedMap(MemoryTracker memoryTracker, long trackedHeap) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedHeap = trackedHeap;
    }

    private HeapTrackingUnifiedMap(int initialCapacity, MemoryTracker memoryTracker) {
        super(initialCapacity);
        long trackedHeap = HeapTrackingUnifiedMap.arrayHeapSize(initialCapacity);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedHeap);
        this.memoryTracker = memoryTracker;
        this.trackedHeap = trackedHeap;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            long heapToAllocate = HeapTrackingUnifiedMap.arrayHeapSize(sizeToAllocate);
            this.memoryTracker.allocateHeap(heapToAllocate);
            this.memoryTracker.releaseHeap(this.trackedHeap);
            this.trackedHeap = heapToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    protected void rehash(int newCapacity) {
        super.rehash(newCapacity);
        int nChains = this.getCollidingBuckets();
        long estimatedHeapUsageForChains = (long)nChains * HeapTrackingUnifiedMap.arrayHeapSize(16);
        this.memoryTracker.allocateHeap(estimatedHeapUsageForChains);
        this.trackedHeap += estimatedHeapUsageForChains;
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE + this.trackedHeap);
    }

    @VisibleForTesting
    public static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
    }
}

